% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{plotMetric}
\alias{plotMetric}
\title{Plot one or more internal metrics for all lcModels}
\usage{
plotMetric(models, name, by = "nClusters", subset, group = character())
}
\arguments{
\item{models}{A \code{lcModels} or list of \code{lcModel} objects to compute and plot the metrics of.}

\item{name}{The name(s) of the metric(s) to compute. If no names are given, the names specified in the \code{latrend.metric} option (WRSS, APPA, AIC, BIC) are used.}

\item{by}{The argument name along which methods are plotted.}

\item{subset}{Logical expression based on the \code{lcModel} method arguments, indicating
which \code{lcModel} objects to keep.}

\item{group}{The argument names to use for determining groups of different models. By default,
all arguments are included.
Specifying \code{group = character()} disables grouping.
Specifying a single argument for grouping uses that specific column as the grouping column.
In all other cases, groupings are represented by a number.}
}
\value{
\code{ggplot2} object.
}
\description{
Plot one or more internal metrics for all lcModels
}
\section{Functionality}{

\itemize{
\item \link[=print.lcModels]{Print} an argument summary for each of the models.
\item \link[=as.data.frame.lcModels]{Convert} to a \code{data.frame} of method arguments.
\item \link[=subset.lcModels]{Subset} the list.
\item Compute an \link[=metric]{internal metric} or \link[=externalMetric]{external metric}.
\item Obtain the best model according to \link[=min.lcModels]{minimizing} or \link[=max.lcModels]{maximizing} a \link[=latrend-metrics]{metric}.
\item Obtain the summed \link[=estimationTime]{estimation time}.
\item \link[=plotMetric]{Plot a metric} across a variable.
\item \link[=plotClusterTrajectories]{Plot the cluster trajectories}.
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
methods <- lcMethods(method, nClusters = 1:3)
models <- latrendBatch(methods, latrendData)

if (require("ggplot2")) {
  plotMetric(models, "WMAE")
}

if (require("ggplot2") && require("clusterCrit")) {
  plotMetric(models, c("WMAE", "Dunn"))
}
}
\seealso{
Other lcModels functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels-class}},
\code{\link{lcModels}},
\code{\link{max.lcModels}()},
\code{\link{min.lcModels}()},
\code{\link{print.lcModels}()},
\code{\link{subset.lcModels}()}
}
\concept{lcModels functions}
