% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{min.lcModels}
\alias{min.lcModels}
\title{Select the lcModel with the lowest metric value}
\usage{
\method{min}{lcModels}(x, name, ...)
}
\arguments{
\item{x}{The \code{lcModels} object}

\item{name}{The name of the internal metric.}

\item{...}{Additional arguments.}
}
\value{
The lcModel with the lowest metric value
}
\description{
Select the lcModel with the lowest metric value
}
\examples{
data(latrendData)
baseMethod <- lcMethodKML(response = "Y", id = "Id", time = "Time")
kml1 <- latrend(baseMethod, nClusters = 1, latrendData)
kml2 <- latrend(baseMethod, nClusters = 2, latrendData)
kml3 <- latrend(baseMethod, nClusters = 3, latrendData)
models <- lcModels(kml1, kml2, kml3)
min(models, 'WRSS')
}
\seealso{
\link{max.lcModels} \link{externalMetric}
}
