% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodTwoStep.R
\name{lcMethodTwoStep}
\alias{lcMethodTwoStep}
\title{Two-step clustering}
\usage{
lcMethodTwoStep(
  response,
  representationStep,
  clusterStep,
  standardize = scale,
  center = meanNA,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{representationStep}{A \code{function} with signature \verb{function(method, data)} that computes the representation per strata, returned as a \code{matrix}.
Alternatively, \code{representationStep} is a pre-computed representation \code{matrix}.}

\item{clusterStep}{A \code{function} with signature \verb{function(repdata)} that outputs a \code{lcModel}.}

\item{standardize}{A \code{function} to standardize the output \code{matrix} of the representation step. By default, the output is shifted and rescaled to ensure zero mean and unit variance.}

\item{center}{Optional \code{function} for computing the longitudinal cluster centers, with signature \code{(x)}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{...}{Additional arguments.}
}
\description{
Feature-based clustering.
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAKMedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
