% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{msplit}
\alias{msplit}
\title{Split a dataframe for training and testing sets}
\usage{
msplit(df, size = 0.7, seed = 0, print = TRUE)
}
\arguments{
\item{df}{Dataframe}

\item{size}{Numeric. Split rate value, between 0 and 1. If set to
1, the train and test set will be the same.}

\item{seed}{Integer. Seed for random split}

\item{print}{Boolean. Print summary results?}
}
\value{
List with both datasets, summary, and split rate.
}
\description{
This function splits automatically a dataframe into train and
test datasets. You can define a seed to get the same results
every time, but has a default value. You can prevent it from
printing the split counter result.
}
\examples{
data(dft) # Titanic dataset
splits <- msplit(dft, size = 0.7, seed = 123)
names(splits)
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()}

Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{move_files}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Machine Learning}
\concept{Tools}
