% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_post}
\alias{fb_post}
\title{Get Facebook's Post Comments (API Graph)}
\usage{
fb_post(token, post_id, limit = 5000)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{post_id}{Character vector. Post id(s)}

\item{limit}{Integer. Query limit}
}
\value{
data.frame with un-nested processed results fetched with API.
}
\description{
Connect to an API Graph's token and get posts comments given the
post(s) id.
}
\examples{
\dontrun{
token <- YOURTOKEN
ids <- c(POST_ID1, POST_ID2)

# Query 50 comments for two post ids
posts <- fb_post(token, ids, 50)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Facebook: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Facebook}
