% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{plot.paretoTail}
\alias{plot.paretoTail}
\title{Diagnostic plot for the Pareto tail model}
\usage{
\method{plot}{paretoTail}(x, pch = c(1, 3), cex = 1, col = c("black",
  "red"), bg = "transparent", ...)
}
\arguments{
\item{x}{an object of class \code{"paretoTail"} as returned by
\code{\link{paretoTail}}.}

\item{pch,cex,col,bg}{graphical parameters.  Each can be a vector of length
two, with the first and second element giving the graphical parameter for
the good data points and the outliers, respectively.}

\item{\dots}{additional arguments to be passed to
\code{\link{paretoQPlot}}.}
}
\description{
Produce a diagnostic Pareto quantile plot for evaluating the fitted Pareto
distribution.  Reference lines indicating the estimates of the threshold
(scale parameter) and the shape parameter are added to the plot, and any
detected outliers are highlighted.
}
\details{
While the first horizontal line indicates the estimated threshold (scale
parameter), the estimated shape parameter is indicated by a line whose slope
is given by the reciprocal of the estimate.  In addition, the second
horizontal line represents the theoretical quantile of the fitted
distribution that is used for outlier detection.  Thus all values above that
line are the detected outliers.
}
\examples{
data(eusilc)

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090,
    groups = eusilc$db030)

# estimate shape parameter
fit <- paretoTail(eusilc$eqIncome, k = ts$k,
    w = eusilc$db090, groups = eusilc$db030)

# produce plot
plot(fit)
}
\author{
Andreas Alfons
}
\references{
A. Alfons and M. Templ (2013) Estimation of Social Exclusion Indicators
from Complex Surveys: The \R Package \pkg{laeken}.  \emph{Journal of
Statistical Software}, \bold{54}(15), 1--25.  URL
\url{http://www.jstatsoft.org/v54/i15/}
}
\seealso{
\code{\link{paretoTail}}, \code{\link{paretoQPlot}}
}
\keyword{hplot}

