% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.l2boost.R
\name{residuals.l2boost}
\alias{residuals.l2boost}
\title{Model residuals for the training set of an l2boost model object}
\usage{
\method{residuals}{l2boost}(object, m = NULL, ...)
}
\arguments{
\item{object}{an l2boost object for the extraction of model coefficients.}

\item{m}{the iteration number with the l2boost path. 
If m=NULL, the coefficients are obtained from the last iteration M.}

\item{...}{arguments (unused)}
}
\value{
a vector of n residuals
}
\description{
\code{\link{residuals}} is a generic function which extracts model residuals 
from objects returned by modeling functions.

\code{\link{residuals.l2boost}} returns the training set residuals from an \code{\link{l2boost}}
object. By default, the residuals are returned at the final iteration step m=M.
}
\examples{
#--------------------------------------------------------------------------
# Example: Diabetes 
#  
# For diabetes data set, see Efron B., Hastie T., Johnstone I., and Tibshirani R. 
# Least angle regression. Ann. Statist., 32:407-499, 2004.
data(diabetes, package = "l2boost")

l2.object <- l2boost(diabetes$x,diabetes$y, M=1000, nu=.01)
rsd<-residuals(l2.object)
rsd.mid <- residuals(l2.object, m=500)

# Create diagnostic plots
par(mfrow=c(2,2))
qqnorm(residuals(l2.object), ylim=c(-3e-13, 3e-13))
qqline(residuals(l2.object), col=2)

qqnorm(residuals(l2.object, m=500), ylim=c(-3e-13, 3e-13))
qqline(residuals(l2.object, m=500), col=2)

# Tukey-Anscombe's plot
plot(y=residuals(l2.object), x=fitted(l2.object), main="Tukey-Anscombe's plot",
   ylim=c(-3e-13, 3e-13))
lines(smooth.spline(fitted(l2.object), residuals(l2.object), df=4), type="l", 
  lty=2, col="red", lwd=2)
abline(h=0, lty=2, col = 'gray')

plot(y=residuals(l2.object, m=500), x=fitted(l2.object, m=500), main="Tukey-Anscombe's plot", 
  ylim=c(-3e-13, 3e-13))
lines(smooth.spline(fitted(l2.object,m=500), residuals(l2.object, m=500), df=4), type="l", 
  lty=2, col="red", lwd=2)
abline(h=0, lty=2, col = 'gray')


}
\seealso{
\code{\link{residuals}} and \code{\link{l2boost}} and \code{\link{predict.l2boost}}
}
