% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsp.R
\name{kzpdr}
\alias{kzpdr}
\alias{kzpdr.3d}
\alias{kzpdr.estimate}
\alias{kzpdr.eval}
\alias{kzpdr.search}
\alias{kzpdr.spikes}
\alias{kzpdr.valid}
\title{Average Periodogram for Spatial Data in Given Directions}
\usage{
kzpdr(ds, angle, plot = F, pair = T, ...)

kzpdr.spikes(rec = ls(1))

kzpdr.3d(ds, angle, ...)

kzpdr.eval(rec = ls(1), t.D = 2.5, t.F = 0.01, ...)

kzpdr.search(rec = ls(1), t.D = seq(1, 10, 1), t.F = 0.01)

kzpdr.valid(rec = ls(1), t.D = 3, t.F = 0.01, ...)

kzpdr.estimate(rec = ls(1), scale = c(0.005, 1), ...)
}
\arguments{
\item{ds}{Data array. Only 2 dimensional arrays are allowed for current version.}

\item{angle}{Vector or single numeric value in radians.}

\item{plot}{TRUE or FLASE. Flag for outputting designed periodogram plot or not.
       Defaults to FLASE. In \code{kzpdr}, the plot is the mean periodogram 
for data series in a given direction.}

\item{pair}{Logic. Defaults to TRUE, i.e., check the given directions and their
orthogonal opposition at the same time.}

\item{...}{Other arguments. 
\itemize{
 \item     For function \code{kzpdr}, it could be the following arguments
    (right of equals signs are their default setting):
\itemize{
 \item  \code{w = 20 : } smoothing window size.
 \item  \code{dpct = 0.01 : } a percentage of total variation of periodogram;
      smoothing window is extended until variation within the window 
      reaches this number. See DZ method in \code{kzft::kzp} for details.
 \item  \code{rg = c(0,0.5) : } the frequency range for the periodogram.
 \item  \code{raw = FALSE : } if use the raw periodogram directly. 
 \item  \code{log = FALSE : } if use log scale for periodogram.
 \item  \code{frun = FALSE :} if force to run the sampling on given directions.
      Defaults to check records and not sample on duplicate directions
 \item  \code{min.ln = 0.6 :} the minimum ratio of sampling data length vs. 
      original data length to product a periodogram for a direction.
}    

 \item    In \code{kzpdr.3d} function, it could be arguments of 
    the perspective plot, like \code{theta}, \code{phi}, etc.,
    please refer function \code{graphics::persp} for more 
    information.

 \item    For \code{kzpdr.valid}, \code{level} control the cross-validation
    process: integer number \code{k} means to run cross-validation
    by excluding \code{k} pairs of directional samples each time. 
    Default value is 1.
}}

\item{rec}{Data frame or list of the outputs of function \code{kzpdr}. 
Includes the marked frequency values and corresponding directions.
Defaults is searching for the available records in the environment.}

\item{t.D}{Tolerance of direction (in degree).}

\item{t.F}{Tolerance of frequency.}

\item{scale}{The scale of gridding data.}
}
\value{
The returned data list of function \code{kzpdr} includes the 
		data frame for frequencies of spikes on mean periodograms 
		of each checked direction. 

		    Both \code{kzpdr.eval} and \code{kzpdr.estimate} will provide suggested 
			wave frequency and direction values. The data frame of detailed estimation 
		for each direction are also include in their outputs. Beside these,   
		\code{kzpdr.estimate} can generate 3D or 2D plots for the supports of each 
		suggested wave on direction-frequency parameter plane. 
		
		    \code{kzpdr.3d} returns back the data frame for re-gridded mean 
			periodogram for data series in given direction, as showed in the 
		perspective plot.
}
\description{
Functions in this group are designed to check periodogram for data series 
in a given direction or a list of directions. 

   \code{kzpdr} samples the data of wave field, and outputs the average
pattern of periodogram for series in a given direction. A collection of 
these pattern records will be sent to \code{kzpdr.eval} or \code{kzpdr.estimate} 
to estimate the wave frequecies and directions.
}
\details{
The average periodograms for a few pairs of orthogonal spatial
		directions can help to identify frequencies and directions of waves.

		    First, function \code{kzpdr} samples the spatial data and generates 
		periodograms in orthogonal direction pairs, and the frequencies of spikes 
		for each directional periodogram are identified and recorded as the output. 

			Then, \code{kzpdr.spikes} can be used to summarized the outputs of  
		\code{kzpdr}. Function \code{kzpdr.eval} or \code{kzpdr.estimate} all
		can be used to estimate the wave parameters (frequencies and directions).
		\code{kzpdr.estimate} can provide visualization of the results, and it is
		more convenient to use.

		    Usually, if noise level is low, periodograms of a few direction pairs 
		may provide satisfied results. But when the noise is high, you may need to 
		intensively sample on different directions over the spatial data array with 
		\code{kzpdr}. Generally speaking, when the number of samples increases,
		the estimation will become more stable and reliable. 

			Some other functions could be helpful in this procedure. \code{kzpdr.search}
		will search the feasible tolerance settings for wave parameter estimation; 
		Function \code{kzpdr.valid} can provide some kind of cross-validation information
		for the estimation results of \code{kzpdr.eval} and \code{kzpdr.estimate};
		Function \code{kzpdr.3d} will provide 3D perspective plot as the global view for  
		periodograms of data series in a given direction.
}
\examples{
dx <- 300			 
dy <- 300			 

b <- expand.grid(x=1:dx, y=1:dy)
q1 <- pi/3; f1 <- 0.2;
b$v1 <- sin(f1*2*pi*(b$x*cos(q1)+b$y*sin(q1))+100*runif(1))
q2 <- pi/6; f2 <- 0.05;
b$v2 <- sin(f2*2*pi*(b$x*cos(q2)+b$y*sin(q2))+100*runif(1))

a <- array(0,c(dx,dy))
a[as.matrix(b[,1:2])] <- b$v1 + 1.5*b$v2
# persp(1:dx, 1:dy, a, theta=90, phi=-110, 
#	ticktype="detailed", col="lightblue")
a <- a + 5*matrix(rnorm(dx*dy,0,1),ncol=dy)
# persp(1:dx, 1:dy, a, theta=90, phi=-110, 
#	ticktype="detailed", col="lightblue")

# It may take a few minutes
# o <- kzpdr.3d(a, -pi/6)

# sampling, it may take a few minutes 
# e <- kzpdr(a, c(0, pi/4, pi/3, -pi/3, pi/18), plot=TRUE)

# load pre-saved data to save running-time
data(kzpdr.demo); e <- kzpdr.demo; rm(kzpdr.demo)

# counting spikes
kzpdr.spikes(e)

# search for tolerance 
kzpdr.search(e, t.D = c(1,2,3), t.F = c(0.005))

# estimate the wave parameters
kzpdr.eval(e, t.D = 3, t.F = 0.01)

# visualization
kzpdr.estimate(e)
}
\seealso{
\code{\link[kzft]{kzp}}, \code{\link{kzp2}}
}
\concept{
Kolmogorov-Zurbenko periodogram

directional periodogram

average periodogram
}
\keyword{directional-periodogram}

