% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/konfound.R
\name{konfound}
\alias{konfound}
\title{Konfound Analysis for Various Model Types}
\usage{
konfound(
  model_object,
  tested_variable,
  alpha = 0.05,
  tails = 2,
  index = "RIR",
  to_return = "print",
  two_by_two = FALSE,
  n_treat = NULL,
  switch_trm = TRUE,
  replace = "control"
)
}
\arguments{
\item{model_object}{A model object produced by `lm`, `glm`, or `lme4::lmer`.}

\item{tested_variable}{Variable associated with the coefficient to be tested.}

\item{alpha}{Significance level for hypothesis testing.}

\item{tails}{Number of tails for the test (1 or 2).}

\item{index}{Type of sensitivity analysis ('RIR' by default).}

\item{to_return}{Type of output to return ('print', 'raw_output', 'table').}

\item{two_by_two}{Boolean; if `TRUE`, uses a 2x2 table approach 
for `glm` dichotomous variables.}

\item{n_treat}{Number of treatment cases 
(used only if `two_by_two` is `TRUE`).}

\item{switch_trm}{Boolean; switch treatment and control in the analysis.}

\item{replace}{Replacement method for treatment cases ('control' by default).}
}
\value{
Depending on `to_return`, prints the result, returns a raw output, 
or a summary table.
}
\description{
Performs sensitivity analysis on fitted models including 
linear models (`lm`), generalized linear models (`glm`), 
and linear mixed-effects models (`lmerMod`).
It calculates the amount of bias required to invalidate or 
sustain an inference,and the impact of an omitted variable 
necessary to affect the inference.
}
\examples{
# using lm() for linear models
m1 <- lm(mpg ~ wt + hp, data = mtcars)
konfound(m1, wt)
konfound(m1, wt, to_return = "table")

# using glm() for non-linear models
if (requireNamespace("forcats")) {
  d <- forcats::gss_cat

  d$married <- ifelse(d$marital == "Married", 1, 0)

  m2 <- glm(married ~ age, data = d, family = binomial(link = "logit"))
  konfound(m2, age)
}

# using lme4 for mixed effects (or multi-level) models
if (requireNamespace("lme4")) {
  library(lme4)
  m3 <- fm1 <- lme4::lmer(Reaction ~ Days + (1 | Subject), sleepstudy)
  konfound(m3, Days)
}

m4 <- glm(outcome ~ condition, data = binary_dummy_data, family = binomial(link = "logit"))
konfound(m4, condition, two_by_two = TRUE, n_treat = 55)

}
