% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_summary.kRp.lang.R,
%   R/02_method_summary.kRp.TTR.R, R/02_method_summary.kRp.readability.R,
%   R/02_method_summary.kRp.text.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,kRp.lang-method}
\alias{summary,kRp.TTR-method}
\alias{summary,kRp.readability-method}
\alias{summary,kRp.text-method}
\title{Summary methods for koRpus objects}
\usage{
summary(object, ...)

\S4method{summary}{kRp.lang}(object)

\S4method{summary}{kRp.TTR}(object, flat = FALSE)

\S4method{summary}{kRp.readability}(object, flat = FALSE)

\S4method{summary}{kRp.text}(object, index = NA, feature = NULL)
}
\arguments{
\item{object}{An object of class, \code{kRp.lang}, \code{kRp.readability}, 
\code{kRp.text}, or \code{kRp.TTR}.}

\item{...}{Further options, depending on the object class.}

\item{flat}{Logical, if TRUE only a named vector of main results is returned}

\item{index}{Either a vector indicating which rows should be considered as transformed for the statistics,
or the name of a particular transformation that was previously done to the object,
      if more than one transformation was applied.
If \code{NA}, all rows where \code{"equal"} is \code{FALSE} are used.
Only valid for objects providing a \code{diff} feature.}

\item{feature}{A character string naming a feature present in the object,
      to trigger a summary regarding that feature.
Currently only \code{"freq"} is implemented.}
}
\description{
Summary method for S4 objects of classes
\code{\link[koRpus:kRp.lang-class]{kRp.lang}},
\code{\link[koRpus:kRp.readability-class]{kRp.readability}},
\code{\link[koRpus:kRp.text-class]{kRp.text}}, or
\code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.
}
\examples{
\dontrun{
summary(guess.lang("/home/user/data/some.txt", udhr.path="/home/user/data/udhr_txt/"))
}
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  ld.results <- lex.div(tokenized.obj, char=c())
  summary(ld.results)
  summary(ld.results, flat=TRUE)
} else {}
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  rdb.results <- readability(tokenized.obj, index="fast")
  summary(rdb.results)
  summary(rdb.results, flat=TRUE)
} else {}
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  # this will look more useful when you
  # can use treetag() instead of tokenize()
  summary(tokenized.obj)
} else {}
}
\seealso{
\code{\link[koRpus:kRp.lang-class]{kRp.lang}},
   \code{\link[koRpus:kRp.readability-class]{kRp.readability}},
   \code{\link[koRpus:kRp.text-class]{kRp.text}},
   \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}
}
\keyword{methods}
