% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_functions.R
\name{csv_to_kinpair}
\alias{csv_to_kinpair}
\title{Reads \code{.csv} and converts to \code{KinPairData} object}
\usage{
csv_to_kinpair(file, kinship = NULL, lifestage = NULL, ...)
}
\arguments{
\item{file}{The file path to read from}

\item{kinship}{character. kin category to assign or extract from data. one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C , H1C1 or H2C}

\item{lifestage}{character. lifestage to assign or extract from data. one of 'unknown', 'immature' or 'ovipositional'.}

\item{...}{additional arguments to pass to \code{read_csv}}
}
\value{
returns an object of class \code{KinPairData}
}
\description{
This function is part of suite of functions handling file import/export for kinship dispersal objects.

\code{.csv} & \code{.tsv} reading functions at minimum require the .delim file to contain a column titled 'distance' containing distances
between kin pairs. It can optionally contain a column of kinship values 'kinship' as well as a column of lifestage values 'lifestage'.
If the file contains more than one value in the kinship or lifestage columns (e.g. bot 'FS' and 'HS') - the corresponding function
parameter must be set to pick a corresponding subset of dispersed pairs. where parameters are set in the absence of file columns,
these values are assigned to the returned \code{KinPairData} object.
}
\seealso{
Other import_functions: 
\code{\link{df_to_kinpair}()},
\code{\link{read_kindata}()},
\code{\link{tsv_to_kinpair}()},
\code{\link{vector_to_kinpair}()}
}
\concept{import_functions}
