% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot}
\alias{scatterplot}
\title{Scatterplot}
\usage{
scatterplot(
  data = NULL,
  x_var_name = NULL,
  y_var_name = NULL,
  point_label_var_name = NULL,
  weight_var_name = NULL,
  alpha = 1,
  annotate_stats = FALSE,
  line_of_fit_type = "lm",
  ci_for_line_of_fit = FALSE,
  x_axis_label = NULL,
  y_axis_label = NULL,
  point_labels_size_range = c(3, 12),
  jitter_x_percent = 0,
  jitter_y_percent = 0
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{x_var_name}{name of the variable that will go on the x axis}

\item{y_var_name}{name of the variable that will go on the y axis}

\item{point_label_var_name}{name of the variable that will be used to
label individual observations}

\item{weight_var_name}{name of the variable by which to weight
the individual observations for calculating correlation and plotting
the line of fit}

\item{alpha}{opacity of the dots (0 = completely transparent,
1 = completely opaque)}

\item{annotate_stats}{if \code{TRUE}, the correlation and p-value will
be annotated at the top of the plot}

\item{line_of_fit_type}{if \code{line_of_fit_type = "lm"}, a regression
line will be fit; if \code{line_of_fit_type = "loess"}, a local
regression line will be fit; if \code{line_of_fit_type = "none"},
no line will be fit}

\item{ci_for_line_of_fit}{if \code{ci_for_line_of_fit = TRUE},
confidence interval for the line of fit will be shaded}

\item{x_axis_label}{alternative label for the x axis}

\item{y_axis_label}{alternative label for the y axis}

\item{point_labels_size_range}{minimum and maximum size for dots
on the plot when they are weighted}

\item{jitter_x_percent}{horizontally jitter dots by a percentage of the
range of x values}

\item{jitter_y_percent}{vertically jitter dots by a percentage of the
range of y values}
}
\value{
a ggplot object
}
\description{
Creates a scatter plot and calculates a correlation between two variables
}
\examples{
\donttest{
scatterplot(data = mtcars, x_var_name = "wt", y_var_name = "mpg")
scatterplot(
  data = mtcars, x_var_name = "wt", y_var_name = "mpg",
  point_label_var_name = "hp", weight_var_name = "drat",
  annotate_stats = TRUE
)
scatterplot(
  data = mtcars, x_var_name = "wt", y_var_name = "mpg",
  point_label_var_name = "hp", weight_var_name = "cyl",
  annotate_stats = TRUE
)
}
}
