% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_organisations_by_level.R
\name{get_organisations_by_level}
\alias{get_organisations_by_level}
\title{Get Organisations by Level}
\usage{
get_organisations_by_level(
  level = 1,
  org_ids = NULL,
  auth = NULL,
  call = caller_env()
)
}
\arguments{
\item{level}{An integer specifying the desired organisation level (default level 1).}

\item{org_ids}{Optional. A vector of organisation identifiers whose details
are being retrieved.}

\item{auth}{Optional. The authentication object}

\item{call}{The call environment.}
}
\value{
A tibble containing the organisation units and their parent units up
to the specified level.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{get_organisations_by_level()} is an experimental function that retrieves
the organisation units along with their parent units.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch all the organisation units metadata
organisations <- get_organisations_by_level(level = 2)
organisations
\dontshow{\}) # examplesIf}
}
