% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CZUncertainty.R
\name{CZUncertainty}
\alias{CZUncertainty}
\title{CZUncertainty}
\usage{
CZUncertainty(data)
}
\arguments{
\item{data}{The co-ordinates for the location you are trying to predict the climate zone of.}
}
\value{
The uncertainty associated with the located climate zone along with other potential climate zones.
}
\description{
This function will return the uncertainty associated with the predicted climate zone along with other potential climate zones.
}
\examples{
data<- data.frame(Site = c("GC","UFS","NEG"),
  Longitude = c(-15.42,10.98,34.78),
  Latitude = c(27.82,47.42,30.86))
data <- data.frame(data,
  rndCoord.lon = RoundCoordinates(data$Longitude),
  rndCoord.lat = RoundCoordinates(data$Latitude))
data <- data.frame(data,ClimateZ=LookupCZ(data))
data <- data.frame(data, CZUncertainty(data))
}
