% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_timetrend}
\alias{plot_timetrend}
\title{Plot time trend}
\usage{
plot_timetrend(
  x,
  show_topic = NULL,
  time_index_label = NULL,
  quantile_vec = c(0.05, 0.5, 0.95),
  xlab = "Time",
  scales = "fixed",
  width = 0.5,
  show_mean = TRUE,
  ...
)
}
\arguments{
\item{x}{the output from the dynamic keyATM model (see \code{\link[=keyATM]{keyATM()}})}

\item{show_topic}{an integer or a vector. Indicate topics to visualize. Default is \code{NULL}.}

\item{time_index_label}{a vector. The label for time index. The length should be equal to the number of documents (time index provided to \code{\link[=keyATM]{keyATM()}}).}

\item{quantile_vec}{a numeric. Quantiles to visualize}

\item{xlab}{a character.}

\item{scales}{character. Control the scale of y-axis (the parameter in \link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}): \code{free} adjusts y-axis for parameters. Default is \code{fixed}.}

\item{width}{numeric. Width of the error bars.}

\item{show_mean}{logical. The default is \code{TRUE}. This is an option when calculating credible intervals (you need to set \code{store_theta = TRUE} in \code{\link[=keyATM]{keyATM()}}).}

\item{...}{additional arguments not used}
}
\value{
keyATM_fig object
}
\description{
Plot time trend
}
\seealso{
\code{\link[=save_fig]{save_fig()}}
}
