% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{F1}
\alias{F1}
\title{F1 score}
\usage{
F1(ct, multi.class = "macro")
}
\arguments{
\item{ct}{Confusion Matrix.}

\item{multi.class}{Should the results of each class be aggregated, and how?
Options: "none", "macro", "micro". (Defaults: "macro").}
}
\value{
F1 (a single value).
}
\description{
`F1()` computes the F1 score between the output of a classification prediction model
and the actual values of the target.
}
\details{
F1 corresponds to the harmonic mean of Precision and Recall.
}
\examples{
y <- c(rep("a",3),rep("b",2))
y_pred <- c(rep("a",2),rep("b",3))
ct <- table(y,y_pred)
F1(ct)
}
