% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{is.kernelshap}
\alias{is.kernelshap}
\title{Check for kernelshap}
\usage{
is.kernelshap(object)
}
\arguments{
\item{object}{An R object.}
}
\value{
Returns \code{TRUE} if \code{object} has "\code{kernelshap}" among its classes, and \code{FALSE} otherwise.
}
\description{
Is object of class "kernelshap"?
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
pred_fun <- function(X) stats::predict(fit, X)
s <- kernelshap(iris[1:2, -1], pred_fun = pred_fun, iris[-1])
is.kernelshap(s)
is.kernelshap("a")
}
