% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{adaQ}
\alias{adaQ}
\title{models the forward selection of the kernels for the adaptive variant}
\usage{
adaQ(K, select, n)
}
\arguments{
\item{K}{list kernel similarity matrices}

\item{select}{integer vector containing the order of selection of the kernels
in \code{K}. Typically, the \code{selection} field of the output of
\code{\link{FOHSIC}}.}

\item{n}{number of selected kernels. Typically, the \code{n} field of the
output of \code{\link{adaFOHSIC}}.}
}
\value{
list of matrices modeling the quadratic constraints of the
adaptive selection event
}
\description{
Similarly to the fixed variant, the adaptive selection of the
kernels in a forward fashion can also be modeled with a set of
quadratic constraints. The constraints for adaptive selection can be split
into two subsets. The first subset encodes the order of selection of the
kernels, while the second subset encodes the selection of the number of the
kernels. The two subsets are equally sized (\code{length(K) - 1}) and are
sequentially included in the output list.
}
\examples{
n <- 50
p <- 20
K <- replicate(8, matrix(rnorm(n*p), nrow = n, ncol = p), simplify = FALSE)
K <-  sapply(K, function(X) return(X \%*\% t(X) / dim(X)[2]), simplify = FALSE)
L <- matrix(rnorm(n*p), nrow = n, ncol = p)
L <-  L \%*\% t(L) / p
adaS <- adaFOHSIC(K, L)
listQ <- adaQ(K, select = adaS[["selection"]], n = adaS[["n"]])
}
\references{
Loftus, J. R., & Taylor, J. E. (2015). Selective inference in
regression models with groups of variables.
}
