% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_depthwise_conv_2d}
\alias{layer_depthwise_conv_2d}
\title{Depthwise separable 2D convolution.}
\usage{
layer_depthwise_conv_2d(object, kernel_size, strides = c(1, 1),
  padding = "valid", depth_multiplier = 1, data_format = NULL,
  activation = NULL, use_bias = TRUE,
  depthwise_initializer = "glorot_uniform", bias_initializer = "zeros",
  depthwise_regularizer = NULL, bias_regularizer = NULL,
  activity_regularizer = NULL, depthwise_constraint = NULL,
  bias_constraint = NULL, input_shape = NULL, batch_input_shape = NULL,
  batch_size = NULL, dtype = NULL, name = NULL, trainable = NULL,
  weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{kernel_size}{An integer or list of 2 integers, specifying the width and
height of the 2D convolution window. Can be a single integer to specify the
same value for all spatial dimensions.}

\item{strides}{An integer or list of 2 integers, specifying the strides of
the convolution along the width and height. Can be a single integer to
specify the same value for all spatial dimensions. Specifying any stride
value != 1 is incompatible with specifying any \code{dilation_rate} value != 1.}

\item{padding}{one of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{depth_multiplier}{The number of depthwise convolution output channels
for each input channel. The total number of depthwise convolution output
channels will be equal to \code{filterss_in * depth_multiplier}.}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \code{(batch, height, width, channels)} while \code{channels_first} corresponds to inputs with shape \code{(batch, channels, height, width)}. It defaults to the \code{image_data_format} value
found in your Keras config file at \code{~/.keras/keras.json}. If you never set
it, then it will be "channels_last".}

\item{activation}{Activation function to use. If you don't specify anything,
no activation is applied (ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{depthwise_initializer}{Initializer for the depthwise kernel matrix.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{depthwise_regularizer}{Regularizer function applied to the depthwise
kernel matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{depthwise_constraint}{Constraint function applied to the depthwise
kernel matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Depthwise Separable convolutions consists in performing just the first step
in a depthwise spatial convolution (which acts on each input channel
separately). The \code{depth_multiplier} argument controls how many output
channels are generated per input channel in the depthwise step.
}
\seealso{
Other convolutional layers: \code{\link{layer_conv_1d}},
  \code{\link{layer_conv_2d_transpose}},
  \code{\link{layer_conv_2d}},
  \code{\link{layer_conv_3d_transpose}},
  \code{\link{layer_conv_3d}},
  \code{\link{layer_conv_lstm_2d}},
  \code{\link{layer_cropping_1d}},
  \code{\link{layer_cropping_2d}},
  \code{\link{layer_cropping_3d}},
  \code{\link{layer_separable_conv_1d}},
  \code{\link{layer_separable_conv_2d}},
  \code{\link{layer_upsampling_1d}},
  \code{\link{layer_upsampling_2d}},
  \code{\link{layer_upsampling_3d}},
  \code{\link{layer_zero_padding_1d}},
  \code{\link{layer_zero_padding_2d}},
  \code{\link{layer_zero_padding_3d}}
}
