% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_adam}
\alias{optimizer_adam}
\title{Adam optimizer}
\usage{
optimizer_adam(lr = 0.001, beta_1 = 0.9, beta_2 = 0.999,
  epsilon = 1e-08, decay = 0, clipnorm = NULL, clipvalue = NULL)
}
\arguments{
\item{lr}{float >= 0. Learning rate.}

\item{beta_1}{The exponential decay rate for the 1st moment estimates. float,
0 < beta < 1. Generally close to 1.}

\item{beta_2}{The exponential decay rate for the 2nd moment estimates. float,
0 < beta < 1. Generally close to 1.}

\item{epsilon}{float >= 0. Fuzz factor.}

\item{decay}{float >= 0. Learning rate decay over each update.}

\item{clipnorm}{Gradients will be clipped when their L2 norm exceeds this
value.}

\item{clipvalue}{Gradients will be clipped when their absolute value exceeds
this value.}
}
\description{
Adam optimizer as described in \href{https://arxiv.org/abs/1412.6980v8}{Adam - A Method for StochasticOptimization}.
}
\note{
Default parameters follow those provided in the original paper.
}
\seealso{
Other optimizers: \code{\link{optimizer_adadelta}},
  \code{\link{optimizer_adagrad}},
  \code{\link{optimizer_adamax}},
  \code{\link{optimizer_nadam}},
  \code{\link{optimizer_rmsprop}},
  \code{\link{optimizer_sgd}}
}
