% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitter.R
\name{equi_jitter}
\alias{equi_jitter}
\title{Conditionally equidistant jittering}
\usage{
equi_jitter(x)
}
\arguments{
\item{x}{observations; the function does nothing if \code{x} is already numeric.}
}
\description{
Converts ordered variables to numeric and Adds deterministic uniform noise.
See \emph{Details}.
}
\details{
Jittering makes discrete variables continuous by adding noise. This simple
trick allows to consistently estimate densities with tools designed for the
continuous case (see, Nagler, 2018a/b). The drawback is that estimates are
random and the noise may deteriorate the estimate by chance.

Here, we add a form of deterministic noise that makes estimators well
behaved. Tied occurrence of a factor level are spread out uniformly
(i.e., equidistantly) on the interval \eqn{[-0.5, 0.5]}. This is similar to
adding random noise that is uniformly distributed, conditional on the
observed outcome. Integrating over the outcome, one can check that the
unconditional noise distribution is also uniform on \eqn{[-0.5, 0.5]}.

Asymptotically, the deterministic jittering variant is equivalent to the
random one.
}
\examples{
x <- as.factor(rbinom(10, 1, 0.5))
equi_jitter(x)
}
\references{
Nagler, T. (2018a). \emph{A generic approach to nonparametric function estimation
with mixed data.} Statistics & Probability Letters, 137:326–330,
\href{https://arxiv.org/abs/1704.07457}{arXiv:1704.07457}

Nagler, T. (2018b). \emph{Asymptotic analysis of the jittering kernel density
estimator.} Mathematical Methods of Statistics, in press,
\href{https://arxiv.org/abs/1705.05431}{arXiv:1705.05431}
}
