% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm_rbmi.R
\name{rbmi_mmrm}
\alias{rbmi_mmrm}
\title{MMRM Analysis for Imputed Datasets}
\usage{
rbmi_mmrm(
  data,
  vars,
  cov_struct = c("us", "toep", "cs", "ar1"),
  visits = NULL,
  weights = c("counterfactual", "equal"),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr containing the data to be used in the model.}

\item{vars}{(\code{vars})\cr list as generated by \code{\link[rbmi:set_vars]{rbmi::set_vars()}}. Only the \code{subjid}, \code{group},
\code{visit}, \code{outcome} and \code{covariates} elements are required. See details.}

\item{cov_struct}{(\code{string})\cr the covariance structure to use. Note that the same
covariance structure is assumed for all treatment groups.}

\item{visits}{(\code{NULL} or \code{character})\cr An optional character vector specifying
which visits to fit the MMRM at. If \code{NULL}, the MMRM model will be fit to
the whole dataset.}

\item{weights}{(\code{string})\cr the weighting strategy to be used when calculating the
least square means, either \code{'counterfactual'} or \code{'equal'}.}

\item{...}{additional arguments passed to \code{\link[mmrm:mmrm]{mmrm::mmrm()}}, in particular
\code{method} and \code{vcov} to control the degrees of freedom and variance-covariance
adjustment methods as well as \code{reml} decide between REML and ML estimation.}
}
\value{
a list of variance (\verb{var_*}), treatment effect (\verb{trt_*}), and
least square mean (\verb{lsm_*}) estimates for each visit, organized as
described in Details above.
}
\description{
Performs an MMRM for two or more groups returning the estimated
'treatment effect' (i.e. the contrast between treatment groups and the control
group) and the least square means estimates in each group.
}
\details{
The function works as follows:
\enumerate{
\item Optionally select the subset of the \code{data} corresponding to `visits.
\item Fit an MMRM as \code{vars$outcome ~ vars$group + vars$visit + vars$covariates}
with the specified covariance structure for visits within subjects.
\item Extract the 'treatment effect' & least square means for each treatment group
vs the control group.
}

In order to meet the formatting standards set by \code{\link[rbmi:analyse]{rbmi::analyse()}} the results will be collapsed
into a single list suffixed by the visit name, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
   var_B_visit_1 = list(est = ...),
   trt_B_visit_1 = list(est = ...),
   lsm_A_visit_1 = list(est = ...),
   lsm_B_visit_1 = list(est = ...),
   var_B_visit_2 = list(est = ...),
   trt_B_visit_2 = list(est = ...),
   lsm_A_visit_2 = list(est = ...),
   lsm_B_visit_2 = list(est = ...),
   ...
)
}\if{html}{\out{</div>}}

Please note that 'trt' refers to the treatment effects, and 'lsm' refers to the least
square mean results. In the above example \code{vars$group} has two factor levels A and B.
The new 'var' refers to the model estimated variance of the residuals at the given
visit, together with the degrees of freedom (which is treatment group specific).

If you want to include additional interaction terms in your model this can be done
by providing them to the \code{covariates} argument of \code{\link[rbmi:set_vars]{rbmi::set_vars()}}
e.g. \code{set_vars(covariates = c('sex*age'))}.
}
\note{
The \code{group} and \code{visit} interaction \code{group:visit} is not included by
default in the model, therefore please add that to \code{covariates} manually if
you want to include it. This will make sense in most cases.
}
\seealso{
\code{\link[=rbmi_analyse]{rbmi_analyse()}}

\code{\link[mmrm:mmrm]{mmrm::mmrm()}}

\code{\link[rbmi:set_vars]{rbmi::set_vars()}}
}
