% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-constructor.R
\name{jubilee}
\alias{jubilee}
\title{Constructor of the jubilee class}
\usage{
jubilee(dtb, lookback.channel = 45, fwd.rtn.duration = 20,
  force = TRUE)
}
\arguments{
\item{dtb}{data.table from the \code{jubilee.repo} object, typically it is the \code{ie} slot.
The user is allowed to provide custom data object to research different markets,
as long as the column names are compliant.}

\item{lookback.channel}{numeric, look-back channel in years to calculate mean-reversion. Default is 45.}

\item{fwd.rtn.duration}{numeric, forward return duration in years. Default is 20.}

\item{force}{logical, if FALSE, allowed to retrieve previous object stored in option. Default is \code{TRUE}.}
}
\value{
an object of the jubilee class
}
\description{
Construct an jubilee object which holds raw and derived data,
channel regression results, and other derived analytical quantities.
This object is the main object to perform various forecasts and analyses.
}
\examples{
\dontrun{
  repo <- jubilee.repo(online=FALSE)
  ju <- jubilee(repo@ie, 45, 20)
}

}
\author{
Stephen H. Lihn
}
\keyword{constructor}
