% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predictions.R
\name{plot_predictions}
\alias{plot_predictions}
\title{Plot predicted effects from make_predictions}
\usage{
plot_predictions(predictions, pred = NULL, modx = NULL, mod2 = NULL,
  resp = NULL, data = NULL, geom = c("point", "line", "bar",
  "boxplot"), plot.points = FALSE, interval = TRUE,
  pred.values = NULL, modx.values = NULL, mod2.values = NULL,
  linearity.check = FALSE, facet.modx = FALSE, x.label = NULL,
  y.label = NULL, pred.labels = NULL, modx.labels = NULL,
  mod2.labels = NULL, main.title = NULL, legend.main = NULL,
  color.class = NULL, line.thickness = 1.1, vary.lty = NULL,
  jitter = 0, weights = NULL, rug = FALSE, rug.sides = "b",
  force.cat = FALSE, point.shape = FALSE, geom.alpha = NULL,
  dodge.width = NULL, errorbar.width = NULL,
  interval.geom = c("errorbar", "linerange"), pred.point.size = 3.5,
  point.size = 1, ...)
}
\arguments{
\item{predictions}{Either the output from \code{\link[=make_predictions]{make_predictions()}} (an object
of class "predictions") or a data frame of predicted values.}

\item{pred}{The name of the predictor variable involved
in the interaction. This can be a bare name or string.}

\item{modx}{The name of the moderator variable involved
in the interaction. This can be a bare name or string.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction. This can be a bare name or string.}

\item{resp}{What is the name of the response variable? Use a string.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{geom}{\strong{For factor predictors only}: What type of plot should this be?
There are several options
here since the best way to visualize categorical interactions varies by
context. Here are the options:
\itemize{
\item \code{"point"}: The default. Simply plot the point estimates. You may want to
use
\code{point.shape = TRUE} with this and you should also consider
\code{interval = TRUE} to visualize uncertainty.
\item \code{"line"}: This connects observations across levels of the \code{pred}
variable with a line. This is a good option when the \code{pred} variable
is ordinal (ordered). You may still consider \code{point.shape = TRUE} and
\code{interval = TRUE} is still a good idea.
\item \code{"bar"}: A bar chart. Some call this a "dynamite plot."
Many applied researchers advise against this type of plot because it
does not represent the distribution of the observed data or the
uncertainty of the predictions very well. It is best to at least use the
\code{interval = TRUE} argument with this geom.
\item \code{"boxplot"}: This geom plots a dot and whisker plot. These can be useful
for understanding the distribution of the observed data without having
to plot all the observed points (especially helpful with larger data
sets). \strong{However}, it is important to note the boxplots are not based
on the model whatsoever.
}}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as
a scatterplot on top of the interaction lines. The color of the dots will
be based on their moderator value.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction
intervals around the line using \code{\link[ggplot2]{geom_ribbon}}.}

\item{pred.values}{Which values of the predictor should be included in the
plot? By default, all levels are included.}

\item{modx.values}{For which values of the moderator should lines be plotted?
Default is \code{NULL}. If \code{NULL}, then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If \code{"plus-minus"}, plots lines when the moderator is at
+/- 1 standard deviation without the mean. You may also choose \code{"terciles"}
to split the data into equally-sized groups and choose the point at the
mean of each of those groups.

If the moderator is a factor variable and \code{modx.values} is
\code{NULL}, each level of the factor is included. You may specify
any subset of the factor levels (e.g., \code{c("Level 1", "Level 3")}) as long
as there is more than 1. The levels will be plotted in the order you
provide them, so this can be used to reorder levels as well.}

\item{mod2.values}{For which values of the second moderator should the plot
be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modx.values}.}

\item{linearity.check}{For two-way interactions only. If \code{TRUE}, plots a
pane for each level of the moderator and superimposes a loess smoothed
line (in gray) over the plot. This enables you to see if the effect is
linear through the span of the moderator. See Hainmueller et al. (2016) in
the references for more details on the intuition behind this. It is
recommended that you also set \code{plot.points = TRUE} and use
\code{modx.values = "terciles"} with this option.}

\item{facet.modx}{Create separate panels for each level of the moderator?
Default is FALSE, except when \code{linearity.check} is TRUE.}

\item{x.label}{A character object specifying the desired x-axis label. If
\code{NULL}, the variable name is used.}

\item{y.label}{A character object specifying the desired x-axis label. If
\code{NULL}, the variable name is used.}

\item{pred.labels}{A character vector of 2 labels for the predictor if it is
a 2-level factor or a continuous variable with only 2 values. If
\code{NULL}, the default, the factor labels are used.}

\item{modx.labels}{A character vector of labels for each level of the
moderator values, provided in the same order as the \code{modx.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{modx,values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd
moderator values, provided in the same order as the \code{mod2.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{mod2.values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{main.title}{A character object that will be used as an overall title
for the plot. If \code{NULL}, no main title is used.}

\item{legend.main}{A character object that will be used as the title that
appears above the legend. If \code{NULL}, the name of the moderating
variable is used.}

\item{color.class}{See \link{jtools_colors} for details on the types of arguments
accepted. Default is "CUD Bright" for factor
moderators, "Blues" for +/- SD and user-specified \code{modx.values}
values.}

\item{line.thickness}{How thick should the plotted lines be? Default is 1.1;
ggplot's default is 1.}

\item{vary.lty}{Should the resulting plot have different shapes for each
line in addition to colors? Default is NULL, which will switch to FALSE
if the \code{pred} is a factor and TRUE if \code{pred} is continuous.}

\item{jitter}{How much should \code{plot.points} observed values be "jittered"
via \code{\link[ggplot2:position_jitter]{ggplot2::position_jitter()}}? When there are many points near each
other, jittering moves them a small amount to keep them from
totally overlapping. In some cases, though, it can add confusion since
it may make points appear to be outside the boundaries of observed
values or cause other visual issues. Default is 0, but try various
small values (e.g., 0.1) and increase as needed if your points are
overlapping too much. If the argument is a vector with two values,
then the first is assumed to be the jitter for width and the second
for the height.}

\item{weights}{If the data are weighted, provide a vector of weights here.
This is only used if \code{plot.points = TRUE} and \code{data} is not NULL.}

\item{rug}{Show a rug plot in the margins? This uses \code{\link[ggplot2:geom_rug]{ggplot2::geom_rug()}}
to show the distribution of the predictor (top/bottom) and/or
response variable (left/right) in the original data. Default is
FALSE.}

\item{rug.sides}{On which sides should rug plots appear? Default is "b",
meaning bottom. "t" and/or "b" show the distribution of the predictor
while "l" and/or "r" show the distribution of the response. "bl" is
a good option to show both the predictor and response.}

\item{force.cat}{Force the predictor to be treated as if it is a factor,
even if it isn't? Default is FALSE. Set to TRUE if you'd like to generate
a type of plot normally reserved for categorical variables. This can be
helpful for numeric variables that have a small number of unique values,
for instance.}

\item{point.shape}{For plotted points---either of observed data or predicted
values with the "point" or "line" geoms---should the shape of the points
vary by the values of the factor? This is especially useful if you aim to
be black and white printing- or colorblind-friendly.}

\item{geom.alpha}{What should the alpha aesthetic be for the plotted
lines/bars? Default is NULL, which means it is set depending on the value
of \code{geom} and \code{plot.points}.}

\item{dodge.width}{What should the \code{width} argument to
\code{\link[ggplot2:position_dodge]{ggplot2::position_dodge()}} be? Default is NULL, which means it is set
depending on the value of \code{geom}.}

\item{errorbar.width}{How wide should the error bars be? Default is NULL,
meaning it is set depending on the value \code{geom}. Ignored if \code{interval}
is FALSE.}

\item{interval.geom}{For categorical by categorical interactions.
One of "errorbar" or "linerange". If the former,
\code{\link[ggplot2:geom_errorbar]{ggplot2::geom_errorbar()}} is used. If the latter,
\code{\link[ggplot2:geom_linerange]{ggplot2::geom_linerange()}} is used.}

\item{pred.point.size}{If TRUE and \code{geom} is \code{"point"} or \code{"line"},
sets the size of the predicted points. Default is 3.5.
Note the distinction from \code{point.size}, which refers to the
observed data points.}

\item{point.size}{What size should be used for observed data when
\code{plot.points} is TRUE? Default is 2.}

\item{...}{Ignored.}
}
\description{
The companion function to \code{\link[=make_predictions]{make_predictions()}}. This takes
data from \code{\link[=make_predictions]{make_predictions()}} (or elsewhere) and plots them like
\code{\link[=effect_plot]{effect_plot()}}, \code{\link[=interact_plot]{interact_plot()}}, and \code{\link[=cat_plot]{cat_plot()}}. Note that some
arguments will be ignored if the inputted predictions
}
\details{
This is designed to offer more flexibility than the canned functions
(\code{\link[=effect_plot]{effect_plot()}}, \code{\link[=interact_plot]{interact_plot()}}, and \code{\link[=cat_plot]{cat_plot()}}), by letting you
generate your own predicted data and iteratively experiment with the
plotting options.

Note: \code{predictions} objects from \code{\link[=make_predictions]{make_predictions()}} store information
about the arguments used to create the object. Unless you specify those
arguments manually to this function, as a convenience \code{plot_predictions}
will use the arguments stored in the \code{predictions} object. Those arguments
are:
\itemize{
\item \code{pred}, \code{modx}, and \code{mod2}
\item \code{resp}
\item \code{pred.values}, \code{modx.values}, and \code{mod2.values}
\item \code{pred.labels}, \code{modx.labels}, and \code{mod2.labels}
\item \code{data}
\item \code{interval}
\item \code{linearity.check}
\item \code{weights}
}
}
\seealso{
Other plotting tools: \code{\link{make_predictions}}
}
\concept{plotting tools}
