% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_discords_hotsax}
\alias{find_discords_hotsax}
\title{Finds a discord (i.e. time series anomaly) with HOT-SAX.
Usually works the best with lower sizes of discretization parameters: PAA and Alphabet.}
\usage{
find_discords_hotsax(ts, w_size, paa_size, a_size, n_threshold, discords_num)
}
\arguments{
\item{ts}{the input timeseries.}

\item{w_size}{the sliding window size.}

\item{paa_size}{the PAA size.}

\item{a_size}{the alphabet size.}

\item{n_threshold}{the normalization threshold.}

\item{discords_num}{the number of discords to report.}
}
\description{
Finds a discord (i.e. time series anomaly) with HOT-SAX.
Usually works the best with lower sizes of discretization parameters: PAA and Alphabet.
}
\examples{
discords = find_discords_hotsax(ecg0606, 100, 3, 3, 0.01, 1)
plot(ecg0606, type = "l", col = "cornflowerblue", main = "ECG 0606")
lines(x=c(discords[1,2]:(discords[1,2]+100)),
   y=ecg0606[discords[1,2]:(discords[1,2]+100)], col="red")
}
\references{
Keogh, E., Lin, J., Fu, A.,
HOT SAX: Efficiently finding the most unusual time series subsequence.
Proceeding ICDM '05 Proceedings of the Fifth IEEE International Conference on Data Mining
}

