# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @importFrom memuse Sys.meminfo Sys.swapinfo
NULL

#' JMatrixSetDebug
#'
#' Sets debugging in jmatrix package to ON (with TRUE) or OFF (with FALSE).\cr
#' On package load the default status is OFF.\cr
#' Setting debugging to ON shows a message. Setting to OFF does not show anything (since debugging is OFF...)
#'
#' @param deb   boolean, TRUE to generate debug messages and FALSE to turn them off. Default: true
#' @return      No return value, called for side effects (internal boolean flag changed)
#' @examples
#' JMatrixSetDebug(TRUE)
#' JMatrixSetDebug(FALSE)
#' @export
JMatrixSetDebug <- function(deb = TRUE) {
    invisible(.Call(`_jmatrix_JMatrixSetDebug`, deb))
}

#' GetJCol
#'
#' Returns (as a R numeric vector) the requested column number from the matrix contained in a jmatrix binary file
#'
#' @param fname  String with the file name that contains the binary data.
#' @param ncol   The number of the column to be returned, in R-numbering (from 1)
#' @return       A numeric vector with the values of elements in the requested column
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,3]
#' vf<-GetJCol(tmpfile1,3)
#' vf
#' @export
GetJCol <- function(fname, ncol) {
    .Call(`_jmatrix_GetJCol`, fname, ncol)
}

#' GetJManyCols
#'
#' Returns (as a R numeric matrix) the columns with the requested column numbers from the matrix contained in a jmatrix binary file
#'
#' @param fname    String with the file name that contains the binary data.
#' @param extcols  A numeric vector with the indexes of the columns to be extracted, in R-numbering (from 1)
#' @return         A numeric matrix with the values of elements in the requested columns
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' vc<-GetJManyCols(tmpfile1,c(1,4))
#' vc
#' @export
GetJManyCols <- function(fname, extcols) {
    .Call(`_jmatrix_GetJManyCols`, fname, extcols)
}

#' GetJColByName
#'
#' Returns (as a R numeric vector) the requested named column from the matrix contained in a jmatrix binary file
#'
#' @param fname   String with the file name that contains the binary data.
#' @param colname The name of the column to be returned. If the matrix has no column names, or the name is not found, an empty vector is returned
#' @return        A numeric vector with the values of elements in the requested column
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,"c"]
#' vf<-GetJColByName(tmpfile1,"c")
#' vf
#' @export
GetJColByName <- function(fname, colname) {
    .Call(`_jmatrix_GetJColByName`, fname, colname)
}

#' GetJManyColsByNames
#'
#' Returns (as a R numeric matrix) the columns with the requested column names from the matrix contained in a jmatrix binary file
#'
#' @param fname        String with the file name that contains the binary data.
#' @param extcolnames  A vector of RStrings with the names of the columns to be extracted. If the binary file has no column names, or _any_ of the column names is not present, an empty matrix is returned.
#' @return             A numeric matrix with the values of elements in the requested columns
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,c(1,4)]
#' vf<-GetJManyColsByNames(tmpfile1,c("a","d"))
#' vf
#' @export
GetJManyColsByNames <- function(fname, extcolnames) {
    .Call(`_jmatrix_GetJManyColsByNames`, fname, extcolnames)
}

#' GetJRow
#'
#' Returns (as a R numeric vector) the requested row number from the matrix contained in a jmatrix binary file
#'
#' @param fname  String with the file name that contains the binary data.
#' @param nrow   The number of the row to be returned, in R-numbering (from 1)
#' @return       A numeric vector with the values of elements in the requested row
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[3,]
#' vf<-GetJRow(tmpfile1,3)
#' vf
#' @export
GetJRow <- function(fname, nrow) {
    .Call(`_jmatrix_GetJRow`, fname, nrow)
}

#' GetJManyRows
#'
#' Returns (as a R numeric matrix) the rows with the requested row numbers from the matrix contained in a jmatrix binary file
#'
#' @param fname    String with the file name that contains the binary data.
#' @param extrows  A numeric vector with the indexes of the rows to be extracted, in R-numbering (from 1)
#' @return         A numeric matrix with the values of elements in the requested rows
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[c(1,4),]
#' vc<-GetJManyRows(tmpfile1,c(1,4))
#' vc
#' @export
GetJManyRows <- function(fname, extrows) {
    .Call(`_jmatrix_GetJManyRows`, fname, extrows)
}

#' GetJRowByName
#'
#' Returns (as a R numeric vector) the requested named row from the matrix contained in a jmatrix binary file
#'
#' @param fname   String with the file name that contains the binary data.
#' @param rowname The name of the row to be returned. If the matrix has no row names, or the name is not found, an empty vector is returned
#' @return        A numeric vector with the values of elements in the requested row
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf["C",]
#' vf<-GetJRowByName(tmpfile1,"C")
#' vf
#' @export
GetJRowByName <- function(fname, rowname) {
    .Call(`_jmatrix_GetJRowByName`, fname, rowname)
}

#' GetJManyRowsByNames
#'
#' Returns (as a R numeric matrix) the rows with the requested row names from the matrix contained in a jmatrix binary file
#'
#' @param fname        String with the file name that contains the binary data.
#' @param extrownames  A vector of RStrings with the names of the rows to be extracted. If the binary file has no row names, or _any_ of the row names is not present, an empty matrix is returned.
#' @return             A numeric matrix with the values of elements in the requested rows
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[c("A","C"),]
#' vf<-GetJManyRowsByNames(tmpfile1,c("A","C"))
#' vf
#' @export
GetJManyRowsByNames <- function(fname, extrownames) {
    .Call(`_jmatrix_GetJManyRowsByNames`, fname, extrownames)
}

#' JMatInfo
#'
#' Shows in the screen or writes to a file information about a matrix stored in the binary format of package jmatrix
#'
#' @param fname  String with the file name that contains the binary data.
#' @param fres   String with the name of the file to write the information. Default: "" (information is written to the console)
#' @return       No return value, called for its side effects (writes on screen or creates a file)
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' JMatInfo(tmpfile1)
#' @export
JMatInfo <- function(fname, fres = "") {
    invisible(.Call(`_jmatrix_JMatInfo`, fname, fres))
}

#' GetJRowNames
#'
#' Returns a R StringVector with the row names of a matrix stored in the binary format of package jmatrix, if it has them stored.
#'
#' @param  fname  String with the file name that contains the binary data.
#' @return A R StringVector with the row names, or the empty vector if the binary file has no row names as metadata.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' rn<-GetJRowNames(tmpfile1)
#' rn
#' @export
GetJRowNames <- function(fname) {
    .Call(`_jmatrix_GetJRowNames`, fname)
}

#' GetJColNames
#'
#' Returns a R StringVector with the column names of a matrix stored in the binary format of package jmatrix, if it has them stored.
#'
#' @param fname  String with the file name that contains the binary data.
#' @return A R StringVector with the column names, or the empty vector if the binaryfile has no column names as metadata.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' cn<-GetJColNames(tmpfile1)
#' cn
#' @export
GetJColNames <- function(fname) {
    .Call(`_jmatrix_GetJColNames`, fname)
}

#' GetJNames
#'
#' Returns a R list of two elements, rownames and colnames, each of them being a R StringVector with the corresponding names
#'
#' @param fname  String with the file name that contains the binary data.
#' @return N["rownames","colnames"]: A list with two elements named rownames and colnames which are R StringVectors.
#'         If the binary file has no row or column names as metadata BOTH will be returned as empty vectors, even if one of them exists.
#'         If you want to extract only one, use either GetJRowNames or GetJColNames, as appropriate.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' N<-GetJNames(tmpfile1)
#' N["rownames"]
#' N["colnames"]
#' @export
GetJNames <- function(fname) {
    .Call(`_jmatrix_GetJNames`, fname)
}

#' JWriteBin
#'
#' Writes a R matrix to a disk file as a binary matrix in the jmatrix format
#'
#'
#' Use this function cautiously. Differently to the functions to get one or more rows or columns from the binary file,
#' which book only the memory strictly needed for the vector/matrix and do not load all the binary file in memory,
#' this function books the full matrix in the requested data type and writes it later so with very big matrices
#' you might run out of memory.\cr
#' Type 'int' is really long int (8-bytes in most modern machines) so using 'int' or 'long' is equivalent.\cr
#' Type is coerced from double (the internal type of R matrices) to the requested type, which may provoke a loose of precision.\cr
#' If M is a named-R matrix, row and column names are written as metadata, too.\cr
#' Also, if you write as symmetric a matrix which is not such, only the lower-diagonal part will be written.
#' The rest of the data will be lost. In this case, if the matrix has row and column names, only row names are written.
#'
#' @param    M The R matrix to be written
#' @param    fname The name of the file to write
#' @param    dtype The data type of the matrix to be written: one of the strings 'short', 'int', 'long', 'float' or 'double'. Default: 'float'
#' @param    dmtype The matrix type: one of the strings 'full', 'sparse' or 'symmetric'. Default: 'full'
#' @param    comment A optional string with the comment to be added as metadata. Default: "" (empty string, no added comment)
#' @return   No return value, called for side effects (creates a file)
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
#' JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
#' @export
JWriteBin <- function(M, fname, dtype = "float", dmtype = "full", comment = "") {
    invisible(.Call(`_jmatrix_JWriteBin`, M, fname, dtype, dmtype, comment))
}

