% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tide_level.R
\name{read_tide_level}
\alias{read_tide_level}
\title{Read and parse tide level text data}
\usage{
read_tide_level(path = NULL, .year, .month, .stn, raw = FALSE)
}
\arguments{
\item{path}{URL or local file path to sea tide level file}

\item{.year}{A.D. 1997 to present year.}

\item{.month}{Month number. 1997 only, valid after March.}

\item{.stn}{Station identification name in uppercase two-digit letters.}

\item{raw}{If \emph{TRUE}, return raw format data}
}
\value{
a \code{tbl} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
# Read a local storage file (dummy data)
read_tide_level(system.file("dummy/tide.txt", package = "jmastats"))
\donttest{
# Request from URL
read_tide_level("https://www.data.jma.go.jp/gmd/kaiyou/data/db/tide/suisan/txt/2020/TK.txt")
# Request from parameters
read_tide_level(.year = 2020, .month = 2, .stn = "TK")
}
}
\seealso{
\url{https://www.data.jma.go.jp/gmd/kaiyou/db/tide/suisan/readme.html}
}
