% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{survfitJMCS}
\alias{survfitJMCS}
\title{survfitJMCS}
\usage{
survfitJMCS(model, ids, estimator, conf.int = TRUE, include.y = FALSE)
}
\arguments{
\item{model}{fitted model object}

\item{ids}{value of id}

\item{estimator}{see \code{survfitjmcs}}

\item{conf.int}{see \code{survfitjmcs}}

\item{include.y}{see \code{survfitjmcs}}
}
\value{
list of predicted value for the given id
}
\description{
prediction of survival probability and longitudinal marker using FastJM for BIG data
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
jmcs1<-jmcsBig(dtlong=data.frame(long2),
dtsurv = data.frame(surv2),
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,
samplesize=200,id='id')
mod2<-jmcs1
P2<-survfitJMCS(model<-mod2,ids<-c(400),estimator = 'median')
pp1<-plot(P2$p1[[1]],estimator="both",include.y = TRUE)
pp1
##
  }
}
