% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw.R
\name{jackstraw.LFA}
\alias{jackstraw.LFA}
\title{Non-Parametric Jackstraw for Logistic Factor Analysis}
\usage{
jackstraw.LFA(dat, FUN = function(x) lfa(x, r)[, , drop = FALSE],
  devR = FALSE, r = NULL, r1 = NULL, s = NULL, B = NULL,
  covariate = NULL, compute.obs = TRUE, compute.null = TRUE,
  compute.p = TRUE, verbose = TRUE, seed = NULL)
}
\arguments{
\item{dat}{a genotype matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{FUN}{a function to use for LFA (by default, it uses the lfagen package)}

\item{devR}{use a R function to compute deviance. By default, FALSE (uses C++).}

\item{r}{a number of significant LFs.}

\item{r1}{a numeric vector of LFs of interest (implying you are not interested in all \code{r} LFs).}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations. There will be a total of \code{s*B} null statistics.}

\item{covariate}{a data matrix of covariates with corresponding \code{n} observations (do not include an intercept term).}

\item{compute.obs}{a logical specifying to return observed statistics. By default, \code{TRUE}.}

\item{compute.null}{a logical specifying to return null statistics obtained by the jackstraw method. By default, \code{TRUE}.}

\item{compute.p}{a logical specifying to return p-values. By default, \code{TRUE}.}

\item{verbose}{a logical specifying to print the computational progress.}

\item{seed}{a seed for the random number generator.}
}
\value{
\code{jackstraw} returns a list consisting of
\item{p.value}{\code{m} p-values of association tests between variables and their LFs}
\item{obs.stat}{\code{m} observed devs}
\item{null.stat}{\code{s*B} null devs}
}
\description{
Estimates statistical significance of association between variables and their logistic factors (LFs).
}
\details{
This function uses logistic factor analysis (LFA) from Wei et al. (2014). Particularly, dev in logistic regression
(the full model with \code{r} LFs vs. the intercept null model) is used to assess association.
}
\examples{
set.seed(1234)
\dontrun{
## simulate genotype data from a logistic factor model: drawing rbinom from logit(BL)
m=5000; n=100; pi0=.9
m0 = round(m*pi0)
m1 = m-round(m*pi0)
B = matrix(0, nrow=m, ncol=1)
B[1:m1,] = matrix(runif(m1*n, min=-.5, max=.5), nrow=m1, ncol=1)
L = matrix(rnorm(n), nrow=1, ncol=n)
BL = B \%*\% L
prob = exp(BL)/(1+exp(BL))

dat = matrix(rbinom(m*n, 2, as.numeric(prob)), m, n)

## apply the jackstraw
out = jackstraw.LFA(dat, r=2)
}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
\seealso{
\link{jackstraw} \link{jackstraw.FUN}
}

