% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sub_models}
\alias{sub_models}
\alias{sub_TN93}
\alias{sub_JC69}
\alias{sub_K80}
\alias{sub_F81}
\alias{sub_HKY85}
\alias{sub_F84}
\alias{sub_GTR}
\alias{sub_UNREST}
\title{Construct necessary information for substitution models.}
\usage{
sub_TN93(pi_tcag, alpha_1, alpha_2, beta)

sub_JC69(lambda)

sub_K80(alpha, beta)

sub_F81(pi_tcag)

sub_HKY85(pi_tcag, alpha, beta)

sub_F84(pi_tcag, beta, kappa)

sub_GTR(pi_tcag, abcdef)

sub_UNREST(Q)
}
\arguments{
\item{pi_tcag}{Vector of length 4 indicating the equilibrium distributions of
T, C, A, and G respectively. Values must be >= 0, and
they are forced to sum to 1.}

\item{alpha_1}{Substitution rate for T <-> C transition.}

\item{alpha_2}{Substitution rate for A <-> G transition.}

\item{beta}{Substitution rate for transversions.}

\item{lambda}{Substitution rate for all possible substitutions.}

\item{alpha}{Substitution rate for transitions.}

\item{kappa}{The transition/transversion rate ratio.}

\item{abcdef}{A vector of length 6 that contains the off-diagonal elements
for the substitution rate matrix.
See \code{vignette("sub-models")} for how the values are ordered in the matrix.}

\item{Q}{Matrix of substitution rates for "T", "C", "A", and "G", respectively.
Item \code{Q[i,j]} is the rate of substitution from nucleotide \code{i} to nucleotide \code{j}.
Do not include indel rates here!
Values on the diagonal are calculated inside the function so are ignored.}
}
\value{
A \code{sub_model_info} object, which is just a wrapper around a list with
fields \code{Q} and \code{pi_tcag}. The former has the rate matrix, and the latter
has the equilibrium nucleotide densities for "T", "C", "A", and "G", respectively.
Access the rate matrix for a \code{sub_model_info} object named \code{x} via \code{x$Q} and
densities via \code{x$pi_tcag}.
}
\description{
For a more detailed explanation, see \code{vignette("sub-models")}.
}
\section{Functions}{
\itemize{
\item \code{sub_TN93}: TN93 model.

\item \code{sub_JC69}: JC69 model.

\item \code{sub_K80}: K80 model.

\item \code{sub_F81}: F81 model.

\item \code{sub_HKY85}: HKY85 model.

\item \code{sub_F84}: F84 model.

\item \code{sub_GTR}: GTR model.

\item \code{sub_UNREST}: UNREST model.
}}

\examples{
# Same substitution rate for all types:
Q_JC69 <- sub_JC69(lambda = 0.1)

# Transitions 2x more likely than transversions:
Q_K80 <- sub_K80(alpha = 0.2, beta = 0.1)

# Same as above, but incorporating equilibrium frequencies
sub_HKY85(pi_tcag = c(0.1, 0.2, 0.3, 0.4),
          alpha = 0.2, beta = 0.1)

}
\seealso{
\code{\link{create_variants}}
}
