% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Jaatha.confidenceIntervals}
\alias{Jaatha.confidenceIntervals}
\title{Function for calculating bootstrap confidence intervals for
jaatha estimates.}
\usage{
Jaatha.confidenceIntervals(jaatha, conf.level = 0.95, replicas = 100,
  cores = 1, log.folder = tempfile("jaatha-logs"), subset = 1:replicas)
}
\arguments{
\item{jaatha}{A jaatha object that was returned by Jaatha.refinedSearch.}

\item{conf.level}{The intended confidence level for the interval.}

\item{replicas}{The number of Jaatha runs that we perform for calculating
the confidence interval. Should be reasonable large.}

\item{cores}{The number of CPU cores that will be used.}

\item{log.folder}{A folder were log-files for the indiviual runs are placed.
The default is to use a temporary folder, even though it is highly
recommended to specify a folder and save the logs.}

\item{subset}{This setting allows you to distribute the CI calculation on
multiple machines. You can specify which replicas should be
run on this machine. Each run is identified by an integer between one and
replicas. All runs which integers are passed as a vector in this arguments
are accutally executed. After all runs have finished, you need to manally
copy all logs into a single folder and call
\code{\link{Jaatha.getCIsFromLogs}} on this folder.}
}
\value{
The Jaatha Object with confidence intervals included if 'subset' was
 not used. Nothing otherwise.
}
\description{
This functions calculates bias-corrected and accelerated (BCa)
bootstrap confidence intervals as described in Section 14.3 of
"An introduction to the bootstrap" by Efron and Tibshirani.
Basically, we simulate many datasets under the model using the estimated
parameters and do a complete Jaatha estimation procedure on each dataset.
We can then use the thereby estimated values
to calculate approximate confidence intervals.
}
\details{
Warning: This requires a large number of Jaatha runs and should
be best executed on a small cluster rather than on a desktop computer.
}

