% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivsacim.R
\name{plot.ivsacim}
\alias{plot.ivsacim}
\title{Plotting Estimated Cumulative Intensity function with Pointwise Confidence Intervals}
\usage{
\method{plot}{ivsacim}(x, gof = FALSE, ...)
}
\arguments{
\item{x}{the fitting object after fitting IVSACIM model}

\item{gof}{whether to draw the goodness-of-fit plot}

\item{...}{the other arguments you want to put in the built-in plot function}
}
\value{
No return value, called for side effects
}
\description{
The function will plot the estimated cumulative intensity function of the treatment after fitting.
Corresponding pointwise confidence intervals at level alpha are also included.
}
\examples{
n = 200
event = rbinom(n, 1, 0.8)
IV = rbinom(n, 1, 0.5)
trt_init = IV
trt_shift = rep(0, n)
time = rexp(n)/(0.5 + trt_init * 0.2)
max_t = 3
max_t_bet = 3
n_sim = 100
fit <- ivsacim(time, event, IV, IV_valid = TRUE, trt_init, 
trt_shift, covar = NULL, max_t, max_t_bet, n_sim)
plot(fit, main = "", xlab = "Time", ylab = "Cumulative Intensity Function")
plot(fit, gof = TRUE, xlab = "Time", ylab = "")
}
