% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{ivmteEstimate}
\alias{ivmteEstimate}
\title{Single iteration of estimation procedure from Mogstad, Torgovitsky,
Santos (2018)}
\usage{
ivmteEstimate(ivlike, data, subset, components, propensity,
  link = "logit", treat, m0, m1, vars_y, vars_mtr, terms_mtr0,
  terms_mtr1, splinesobj, uname = u, target, target.weight0,
  target.weight1, target.knots0 = NULL, target.knots1 = NULL, late.Z,
  late.from, late.to, late.X, eval.X, genlate.lb, genlate.ub,
  obseq.tol = 0.05, grid.nu = 20, grid.nx = 20, audit.nx = 20,
  audit.nu = 20, audit.max = 10, audit.tol = 1e-08, m1.ub, m0.ub,
  m1.lb, m0.lb, mte.ub, mte.lb, m0.dec, m0.inc, m1.dec, m1.inc, mte.dec,
  mte.inc, lpsolver = NULL, point = FALSE, noisy = TRUE,
  seed = 12345)
}
\arguments{
\item{ivlike}{formula or vector of formulas used to specify the
regressions for the IV-like estimands.}

\item{data}{\code{data.frame} used to estimate the treatment
effects.}

\item{subset}{single subset condition or list of subset conditions
corresponding to each IV-like estimand. The input must be
logical. See \code{\link{l}} on how to input the argument. If
the user wishes to select specific rows, construct a binary
variable in the data set, and set the condition to use only
those observations for which the binary variable is 1, e.g. the
binary variable is \code{use}, and the subset condition is
\code{use == 1}.}

\item{components}{a list of vectors of the terms/components from
the regressions specifications we want to include in the set of
IV-like estimands. To select the intercept term, include in the
vector of variable names, `intercept'. See \code{\link{l}} on
how to input the argument. If no components for a IV
specification are given, then all components from that IV
specification will be included.}

\item{propensity}{formula or variable name corresponding to
propensity to take up treatment. If a formula is declared, then
the function estimates propensity score according to the
formula and link specified. If a variable name is declared,
then the corresponding column in the data is taken as the
vector of propensity scores.}

\item{link}{name of link function to estimate propensity score. Can
be chosen from \code{linear}, \code{probit}, or \code{logit}.
Default is set to "logit".}

\item{treat}{variable name for treatment indicator.}

\item{m0}{one-sided formula for marginal treatment response
function for control group. Splines can also be incorporated
using the expression "uSplines(degree, knots, intercept)". The
'intercept' argument may be omitted, and is set to \code{TRUE}
by default.}

\item{m1}{one-sided formula for marginal treatment response
function for treated group. Splines can also be incorporated
using the expression "uSplines(degree, knots, intercept)". The
'intercept' argument may be omitted, and is set to \code{TRUE}
by default.}

\item{vars_y}{character, variable name of observed outcome
variable.}

\item{vars_mtr}{character, vector of variables entering into
\code{m0} and \code{m1}.}

\item{terms_mtr0}{character, vector of terms entering into
\code{m0}.}

\item{terms_mtr1}{character, vector of terms entering into
\code{m1}.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}.}

\item{uname}{variable name for unobservable used in declaring MTRs.}

\item{target}{target parameter to be estimated. Currently function
allows for ATE ("\code{ate}"), ATT ("\code{att}"), ATU
("\code{atu}"), LATE ("\code{late}"), and generalized LATE
("\code{genlate}").}

\item{target.weight0}{user-defined weight function for the control
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.weight1}{user-defined weight function for the treated
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.knots0}{user-defined set of functions defining the
knots associated with splines weights for the control
group. The arguments of the function should consist only of
variable names in \code{data}. If the knot is constant across
all observations, then the user can instead submit the value of
the weight instead of a function.}

\item{target.knots1}{user-defined set of functions defining the
knots associated with splines weights for the treated
group. The arguments of the function should be variable names
in \code{data}. If the knot is constant across all
observations, then the user can instead submit the value of the
weight instead of a function.}

\item{late.Z}{vector of variable names used to define the LATE.}

\item{late.from}{baseline set of values of Z used to define the
LATE.}

\item{late.to}{comparison set of values of Z used to define the
LATE.}

\item{late.X}{vector of variable names of covariates which we
condition on when defining the LATE.}

\item{eval.X}{numeric vector of the values at which we condition
variables in \code{late.X} on when estimating the LATE.}

\item{genlate.lb}{lower bound value of unobservable u for
estimating generalized LATE.}

\item{genlate.ub}{upper bound value of unobservable u for
estimating generalized LATE.}

\item{obseq.tol}{threshold for violation of observational
equivalence. The threshold enters in multiplicatively. Thus, a
value of 0 corresponds to no violation of observational
equivalence other than statistical noise, and the assumption
that the model is correctly specified.}

\item{grid.nu}{number of evenly spread points in the interval [0,
1] of the unobservable u used to form the grid for imposing
shape restrictions on the MTRs.}

\item{grid.nx}{number of evenly spread points of the covariates to
use to form the grid for imposing shape restrictions on the
MTRs.}

\item{audit.nx}{number of points on the covariates space to audit
in each iteration of the audit procedure.}

\item{audit.nu}{number of points in the interval [0, 1],
corresponding to the normalized value of the unobservable term,
to audit in each iteration of the audit procedure.}

\item{audit.max}{maximum number of iterations in the audit
procedure.}

\item{audit.tol}{tolerance for determining when to end the audit
procedure.}

\item{m1.ub}{numeric value for upper bound on MTR for treated
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m0.ub}{numeric value for upper bound on MTR for control
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m1.lb}{numeric value for lower bound on MTR for treated
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{m0.lb}{numeric value for lower bound on MTR for control
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{mte.ub}{numeric value for upper bound on treatment effect
paramter of interest.}

\item{mte.lb}{numeric value for lower bound on treatment effect
paramter of interest.}

\item{m0.dec}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone decreasing.}

\item{m0.inc}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone increasing.}

\item{m1.dec}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone decreasing.}

\item{m1.inc}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone increasing.}

\item{mte.dec}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{mte.inc}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{lpsolver}{name of the linear programming package in R used to
obtain the bounds on the treatment effect.}

\item{point}{boolean, default set to \code{FALSE}. Set to
\code{TRUE} if it is believed that the treatment effects are
point identified. If set to \code{TRUE}, then a GMM procedure
is implemented to estimate the treatment effects. Shape
constraints on the MTRs will be ignored under point
identification.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}

\item{seed}{integer, the seed that determines the random grid
in the audit procedure.}
}
\value{
Returns a list of results from throughout the estimation
    procedure. This includes all IV-like estimands; the propensity
    score model; bounds on the treatment effect; the estimated
    expectations of each term in the MTRs; the components and
    results of the LP problem.
}
\description{
This function estimates bounds on treatment effect parameters,
following the procedure described in Mogstad, Torgovitsky
(2017). Of the target parameters, the user can choose from the ATE,
ATT, ATU, LATE, and generalized LATE. The user is required to
provide a polynomial expression for the marginal treatment
responses (MTR), as well as a set of regressions. By restricting
the set of coefficients on each term of the MTRs to be consistent
with the regression estimates, the function is able to restrict
itself to a set of MTRs. The bounds on the treatment effect
parameter correspond to finding coefficients on the MTRs that
maximize their average difference.
}
\details{
The estimation procedure relies on the propensity to take up
treatment. The propensity scores can either be estimated as part of
the estimation procedure, or the user can specify a variable in the
data set already containing the propensity scores.

Constraints on the shape of the MTRs and marginal treatment effects
(MTE) can be imposed by the user, also. Specifically, bounds and
monotonicity restrictions are permitted. These constraints are only
enforced over a subset of the data. However, an audit procedure
randomly selects points outside of this subset to determine whether
or not the constraints hold. The user can specify how stringent
this audit procedure is using the function arguments.
}
