% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{find_difference}
\alias{find_difference}
\title{Return the regions in which the smooth is significantly different from zero.}
\usage{
find_difference(mean, se, xVals = NULL, f = 1, as.vector = FALSE)
}
\arguments{
\item{mean}{A vector with smooth predictions.}

\item{se}{A vector with the standard error on the smooth predictions.}

\item{xVals}{Optional vector with x values for the smooth. 
When \code{xVals} is provided, the regions are returned in terms of x-
values, otherwise as indices.}

\item{f}{A number to multiply the \code{se} with, to convert the \code{se} 
into confidence intervals. Use 1.96 for 95\% CI and 2.58 for 99\%CI.}

\item{as.vector}{Logical: whether or not to return the data points as 
vector, or not. Default is FALSE, and a list with start and end points will
 be returned.}
}
\value{
The function returns a list with start points of each region 
(\code{start}) and end points of each region (\code{end}). The logical 
\code{xVals} indicates whether the returned values are on the x-scale 
(TRUE) or indices (FALSE).
}
\description{
Return the regions in which the smooth is significantly different from zero.
}
\examples{
data(simdat)

# Use aggregate to calculate mean and standard deviation per timestamp:
avg <- aggregate(simdat$Y, by=list(Time=simdat$Time),
    function(x){c(mean=mean(x), sd=sd(x))})
head(avg)
# Note that column x has two values in each row:
head(avg$x)
head(avg$x[,1])

# Plot line and standard deviation:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   shade=TRUE, lty=3, lwd=3)

# Show difference with 0:
x <- find_difference(avg$x[,'mean'], avg$x[,'sd'], xVals=avg$Time)
# Add arrows:
abline(v=c(x$start, x$end), lty=3, col='red')
arrows(x0=x$start, x1=x$end, y0=-5, y1=-5, code=3, length=.1, col='red')
}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{missing_est}},
  \code{\link{print_summary}}, \code{\link{summary_data}},
  \code{\link{timeBins}}
}
\author{
Jacolien van Rij
}
