% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_utility_functions.R
\name{gradientLegend}
\alias{gradientLegend}
\title{Utility function.}
\usage{
gradientLegend(valRange, color = "topo", nCol = 30, pos = 0.5, side = 4,
  length = 0.25, depth = 0.05, inside = TRUE, coords = FALSE,
  n.seg = 3, border.col = "black")
}
\arguments{
\item{valRange}{Range of the values that is represented by the color
palette. Normally two value-vector. If a larger vector is provided, only
the min and max values are being used.}

\item{color}{Name of color palette to use ('topo', 'terrain', 'heat',
'rainbow'). Custom color palettes can also be provided, but then the
argument \code{nCol} is ignored.}

\item{nCol}{Number of colors in the color palette.}

\item{pos}{A number indicating the position on the axis in proportion.
Using the arguments \code{length} and \code{depth} and \code{side} the
position of the legend is calculated automatically. Alternatively, one
could provide  a vector with 4 numbers, providing the xleft, ybottom,
xright, ytop of a rectangle. These 4 points are indicated in proportions of
the x- and y-axis. However, if the argument \code{coords} is set to TRUE,
these positions are taken as values in the Cartesian coordinate system of
the plot. Note: \code{coords} is only considered for 4-number vectors of
\code{pos}.}

\item{side}{Which axis to choose: 1=bottom, 2=left, 3=top, 4=right.
Default is 4.}

\item{length}{Number, indicating the width of the legend as proportion with
respect to the axis indicated by \code{side}.
Note: when \code{pos} is defined by 4 numbers, \code{length} is ignored.}

\item{depth}{Number, indicating the height of the legend as proportion
with respect to the axis perpendicular to \code{side}.
Note: when \code{pos} is defined by 4 numbers, \code{depth} is ignored.}

\item{inside}{Logical: whether or not to plot the legend inside or outside
the plot area.
Note: when \code{pos} is defined by 4 numbers, \code{inside} is ignored.}

\item{coords}{Logical: whether or not \code{pos} is defined as coordinates.
When FALSE, the default, \code{pos} is defined in proportions.
Note: when \code{pos} is defined by 1 number, \code{inside} is ignored.}

\item{n.seg}{Number of ticks and markers on the scale.}

\item{border.col}{Color of the border and the ticks.}
}
\description{
Add a gradient legend to a contour plot (or other plot) to
indicate the range of values represented by the color palette.
}
\examples{
data(simdat)
# simple GAM model:
m1 <- bam(Y~te(Time, Trial), data=simdat)

# The functions pvisgam and fvisgam automatically plot legend,
# but vis.gam does not:
vis.gam(m1, view=c("Time", "Trial"), plot.type='contour', color='topo',
zlim=c(-14,14) )
gradientLegend(valRange=c(-14,14),pos=.5, side=3)
gradientLegend(valRange=c(-14,14),pos=.125, side=4, inside=FALSE)
gradientLegend(valRange=c(-14,14),pos=.75, length=.5,
color=alphaPalette('white', f.seq=seq(0,1, by=.1)), border.col='white')

# when defining custom points, it is still important to specify side:
gradientLegend(valRange=c(-14,14), pos=c(500,-5,1250,-4), coords=TRUE,
border.col='red', side=1)

# The functions fvisgam, pvisgam, and plot_diff2 output the zlim:
fvg <- fvisgam(m1, view=c("Time", "Trial"), add.color.legend=FALSE)
fadeRug(simdat$Time, simdat$Trial)
gradientLegend(round(fvg$zlim,2), pos=.875)
}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions for plotting: \code{\link{addInterval}};
  \code{\link{alphaPalette}}; \code{\link{alpha}};
  \code{\link{color_contour}}; \code{\link{dotplot_error}};
  \code{\link{emptyPlot}}; \code{\link{errorBars}};
  \code{\link{fadeRug}}; \code{\link{fill_area}};
  \code{\link{find_difference}}; \code{\link{getCoords}};
  \code{\link{getFigCoords}}; \code{\link{horiz_error}};
  \code{\link{plot_error}}
}

