% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acf_resid.R
\name{acf_resid}
\alias{acf_resid}
\title{Generate an ACF plot of model residuals. Works for lm, lmer, gam, bam, ....}
\usage{
acf_resid(model, split_pred = NULL, n = 1, plot = TRUE, ...)
}
\arguments{
\item{model}{A regression model generated by \code{lm}, \code{glm},
\code{lmer}, \code{glmer}, \code{\link[mgcv]{gam}},
or \code{\link[mgcv]{bam}}.
(See examples for how to avoid errors due to missing values.)}

\item{split_pred}{Vector with names of model predictors that determine
the time series in the data, or should be used to split the ACF plot by.
Alternatively, \code{split_pred} can be a names list as being used by
\code{\link{acf_plot}} and \code{\link{acf_n_plots}}.}

\item{n}{The number of plots to generate. If \code{n}=1 (default) then
\code{\link{acf_plot}} is being called. If \code{n}>1 then
\code{\link{acf_n_plots}} is being called.}

\item{plot}{Logical: whether or not to produce plot. Default is TRUE.}

\item{...}{Other arguments as input for \code{\link{acf_plot}}
or \code{\link{acf_n_plots}}.}
}
\value{
An aggregated ACF plot and / or optionally a list with the aggregated ACF values.
}
\description{
Wrapper around \code{\link{acf_plot}} and
\code{\link{acf_n_plots}} for regression models.
}
\examples{
data(simdat)

# add missing values to simdat:
simdat[sample(nrow(simdat), 15),]$Y <- NA

\dontrun{
# Run GAMM model:
m1 <- bam(Y ~ te(Time, Trial)+s(Subject, bs='re'), data=simdat)

# Using a list to split the data:
acf_resid(m1, split_pred=list(simdat$Subject, simdat$Trial))
# ...or using model predictors:
acf_resid(m1, split_pred=c("Subject", "Trial"))

# Calling acf_n_plots:
acf_resid(m1, split_pred=c("Subject", "Trial"), n=4)
# add some arguments:
acf_resid(m1, split_pred=c("Subject", "Trial"), n=4, max_lag=10)

# This does not work...
m2 <- lm(Y ~ Time, data=simdat)
acf_resid(m2, split_pred=c("Subject", "Trial"))
# ... but this is ok:
acf_resid(m2, split_pred=list(simdat$Subject, simdat$Trial))

# See acf_plot for how to deal wit missing data
}
# see the vignette for examples:
vignette("acf", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Use \code{\link[stats]{acf}} for the original ACF function,
and \code{\link{acf_plot}}, or \code{\link{acf_n_plots}}.

Other functions for model criticism: \code{\link{acf_n_plots}};
  \code{\link{acf_plot}}; \code{\link{check_normaldist}};
  \code{\link{resid.gam}}, \code{\link{resid_gam}}
}

