% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/resid_gam.R
\name{resid_gam}
\alias{resid.gam}
\alias{resid_gam}
\title{Extract model residuals and remove the autocorrelation accounted for.}
\usage{
resid_gam(model, AR_start = NULL, incl_na = F, return_all = F)
}
\arguments{
\item{model}{A GAMM model build with \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{AR_start}{Optional: vector with logicals, indicating the start of
events.
Default is NULL, because generally the function can retrieve all necessary
information from the model.}

\item{incl_na}{Whether or not to include missing values (NA)when returning
the residuals. Defaults to FALSE.}

\item{return_all}{Default is FALSE. Returns a list with normal residuals,
corrected residuals, and the value of rho.}
}
\value{
Corrected residuals.
}
\description{
Extract model residuals and remove the autocorrelation accounted for.
}
\examples{
data(simdat)

\dontrun{
# Add start event column:
simdat <- start_event(simdat, event=c("Subject", "Trial"))
head(simdat)
# bam model with AR1 model (toy example, not serious model):
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
   data=simdat, rho=.5, AR.start=simdat$start.event)
# Standard residuals:
acf(resid(m1))
# Corrected residuals:
acf(resid_gam(m1))

# Without AR.start included in the model, resid_gam returns an error:
m2 <- bam(Y ~ Group + te(Time, Trial, by=Group),
   data=simdat)
acf(resid_gam(m2))
# Use resid(m2) instead!
# Alternatively, this also works, essentially the same as resid(m2):
acf(resid_gam(m2, AR_start=simdat$start.event))

### MISSING VALUES ###
# Note that corrected residuals cannot be calculated for the last
# point of each time series. These missing values are by default
# excluded.

# Therefore, this will result in an error...
simdat$res <- resid_gam(m1)
# ... and this will give an error too:
simdat$res <- NA
simdat[!is.na(simdat$Y),] <- resid_gam(m1)
# ... but this works:
simdat$res <- resid_gam(m1, incl_na=TRUE)

# The parameter incl_na will also add missing values
# for missing values in the data.
}
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[stats]{resid}}

Other functions for model criticism: \code{\link{acf_n_plots}};
  \code{\link{acf_plot}}; \code{\link{acf_resid}};
  \code{\link{check_normaldist}}
}

