# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

itp_cpp <- function(f, pars, a, b, ya, yb, epsilon, k1, k2, for_rk, inc) {
    .Call(`_itp_itp_cpp`, f, pars, a, b, ya, yb, epsilon, k1, k2, for_rk, inc)
}

#' Call a C++ function using an external pointer
#'
#' This function is used in \code{\link{plot.itp}} to plot a function and
#' the root estimated by \code{\link{itp}}.
#' @param x The main argument of the function.
#' @param pars A list of additional arguments to the function.  This may be an
#'   empty list.
#' @param xpsexp An external pointer to a C++ function.
#' @details See the
#' \href{https://gallery.rcpp.org/articles/passing-cpp-function-pointers/}{
#' Passing user-supplied C++ functions} article in the
#' \href{https://gallery.rcpp.org/}{Rcpp Gallery} for information.
#' @return A numeric scalar: the value of the C++ function evaluated at the
#'   input values \code{x} and \code{pars}.
#' @examples
#' lambert_ptr <- xptr_create("lambert")
#' res <- itp(lambert_ptr, c(-1, 1))
#'
#' # Value at lower limit
#' xptr_eval(-1, list(), lambert_ptr)
#'
#' # Value at upper limit
#' xptr_eval(1, list(), lambert_ptr)
#'
#' # Value at the estimated root
#' xptr_eval(res$root, list(), lambert_ptr)
#' @seealso \code{\link{xptr_create}} for creating an external pointer to a
#'   C++ function.
#' @export
xptr_eval <- function(x, pars, xpsexp) {
    .Call(`_itp_xptr_eval`, x, pars, xpsexp)
}

wiki_cpp <- function(x, pars) {
    .Call(`_itp_wiki_cpp`, x, pars)
}

neg_wiki_cpp <- function(x, pars) {
    .Call(`_itp_neg_wiki_cpp`, x, pars)
}

lambert_cpp <- function(x, pars) {
    .Call(`_itp_lambert_cpp`, x, pars)
}

trig1_cpp <- function(x, pars) {
    .Call(`_itp_trig1_cpp`, x, pars)
}

poly3_cpp <- function(x, pars) {
    .Call(`_itp_poly3_cpp`, x, pars)
}

linear_cpp <- function(x, pars) {
    .Call(`_itp_linear_cpp`, x, pars)
}

staircase_cpp <- function(x, pars) {
    .Call(`_itp_staircase_cpp`, x, pars)
}

#' Create an external pointer to a C++ function
#'
#' This function is used in \code{\link[itp]{itp-package}} to create
#' external pointers to the C++ functions used as examples to illustrate the
#' use of the function \code{\link{itp}}.  These pointers are passed as the
#' argument \code{f} to \code{\link{itp}}.  To create their own examples
#' the user will need to create their own C++ function a function that is
#' similar to \code{xptr_create}.
#'
#' @param fstr A string indicating the C++ function required.
#' @details See the vignette
#' \href{https://paulnorthrop.github.io/itp/articles/itp-vignette.html}{
#' Overview of the itp package} and the file
#' \href{https://raw.githubusercontent.com/paulnorthrop/itp/main/src/user_fns.cpp}{
#' user_fns.cpp} for information.
#'
#' The example C++ functions available in \code{itp} are: \code{"wiki"},
#' \code{"lambert"}, \code{"trig1"}, \code{"poly3"}, \code{"linear"},
#' \code{"warsaw"} and \code{staircase}.
#' @return The external pointer.
#' @seealso \code{\link{xptr_eval}} for calling a C++ function using an
#'   external pointer.
#' @examples
#' lambert_ptr <- xptr_create("lambert")
#' res <- itp(lambert_ptr, c(-1, 1))
#' @export
xptr_create <- function(fstr) {
    .Call(`_itp_xptr_create`, fstr)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_itp_RcppExport_registerCCallable', PACKAGE = 'itp')
})
