% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.drop.imputer}
\alias{isotree.drop.imputer}
\title{Drop Imputer Sub-Object from Isolation Forest Model Object}
\usage{
isotree.drop.imputer(model, manually_delete_cpp = TRUE)
}
\arguments{
\item{model}{An `isolation_forest` model object.}

\item{manually_delete_cpp}{Whether to manually delete the underlying C++ object after calling this function.

If passing `FALSE`, memory will not be freed until the underlying R 'externalptr' object is garbage-collected,
which typically happens after the next call to `gc()`.

If passing `TRUE`, will manually delete the C++ object held in the 'externalptr' object before nullifying it.
Note that, if somehow one assigned the pointer address to some other R variable through e.g. a deep copy of
the 'externalptr' object (that happened without copying the full model object where this R variable is stored),
then other pointers pointing at the same address might trigger crashes at the moment they are used.

Note that, unless one starts manually fiddling with the internals of model objects and assigning variables to/from
them, it should not be possible to end up in a situation in which an 'externalptr' object ends up deep-copied,
especially when using `lazy_serialization=TRUE`.}
}
\value{
The same `model` object, but now with the imputer removed. \bold{Note that `model` is modified in-place
in any event}.
}
\description{
Drops the imputer sub-object from an isolation forest model object, if it was fitted with data imputation
capabilities. The imputer, if constructed, is likely to be a very heavy object which might
not be needed for all purposes.
}
