% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_getters.R
\name{topo}
\alias{topo}
\title{Return the list of topologies, or a unique topology if all identical}
\usage{
topo(nm, simplify = TRUE)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{simplify}{Boolean, return only a unique topology if all topologies are
identical or if there is only one? Default is TRUE.}
}
\value{
A list of the \code{networkModel} topologies or, if all topologies
    are identical (or if there is only one) and \code{simplify} is TRUE, a
    single topology (not wrapped into a single-element list).
}
\description{
Return the list of topologies, or a unique topology if all identical
}
\examples{
aquarium_mod
topo(aquarium_mod)

trini_mod
topo(trini_mod)
}
