% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_lines.R
\docType{methods}
\name{ternary_lines}
\alias{ternary_lines}
\alias{ternary_lines-method}
\alias{ternary_lines,numeric,numeric,numeric-method}
\alias{ternary_lines,ANY,missing,missing-method}
\title{Add Connected Line Segments to a Ternary Plot}
\usage{
ternary_lines(x, y, z, ...)

\S4method{ternary_lines}{numeric,numeric,numeric}(x, y, z, type = "l", ...)

\S4method{ternary_lines}{ANY,missing,missing}(x, type = "l", ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further graphical parameters (see \code{\link[graphics:par]{graphics::par()}}) may also be
supplied as arguments, particularly, line type, \code{lty}, line width, \code{lwd},
color, \code{col} and for \code{type = "b"}, \code{pch}. Also the line characteristics
\code{lend}, \code{ljoin} and \code{lmitre}.}

\item{type}{A \code{\link{character}} string indicating the type of plotting; actually
any of the types as in \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\value{
\code{ternary_lines()} is called it for its side-effects.
}
\description{
Add Connected Line Segments to a Ternary Plot
}
\examples{
## Compositional data
coda <- data.frame(
  X = c(20, 60, 20, 20),
  Y = c(20, 20, 60, 40),
  Z = c(60, 20, 20, 40)
)

## Add lines
ternary_plot(NULL, panel.first = ternary_grid())
ternary_lines(coda, col = "red", lwd = 2)
}
\seealso{
\code{\link[graphics:lines]{graphics::lines()}}

Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_image}()},
\code{\link{ternary_labels}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
