% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{rim}
\alias{rim}
\title{Item-total regressions for the Rasch vs. the interaction model}
\usage{
rim(x, items = NULL, showData = FALSE, shade = 10, ncol = 3, ...)
}
\arguments{
\item{x}{A matrix of scored responses (persons in rows, items in columns)}

\item{items}{The items to plot (column numbers). If NULL, all items will be plotted}

\item{showData}{If TRUE, the observed proportion correct at each sum score will
be shown on the plot. Default is FALSE (show only the regressions)}

\item{shade}{The part of the probability mass for the sum scores to shade out,
shown as percentage. Default is 10: shade the most extreme 10% of the distribution.
Ignored when \code{add=TRUE}.}

\item{ncol}{When plotting  multiple items, the user can suggest the number of
columns in the matrix of plots (up to 3, will be adjusted if necessary)}

\item{...}{Any additional plotting parameters}
}
\description{
Compare the item-total regressions fit by the Rasch model and 
the interaction model, for one, several, or all items in the test.
}
\examples{

rim(Scored, items=2)

}
\author{
Ivailo Partchev, using theory and C code by Gunter Maris
}
\seealso{
\code{\link{interactionModel}}
}
\keyword{models}

