% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_qa}
\alias{filter_qa}
\title{Filter with QA Band}
\usage{
filter_qa(DT, ndvi = "NDVI", qa = "SummaryQA", good = c(0, 1))
}
\arguments{
\item{DT}{data.table of NDVI time series}

\item{ndvi}{ndvi column name. default is 'NDVI'.}

\item{qa}{QA column. default is 'SummaryQA'.}

\item{good}{values which correspond to quality pixels. default is 0 and 1.}
}
\value{
filtered data.table with appended 'filtered' column of "quality" NDVI.
}
\description{
Using QA band information, filter the NDVI time series.
}
\details{
See the details for the example data in ?\code{sampled-ndvi-Landsat-LC08-T1-L2.csv}
and ?\code{sampled-ndvi-MODIS-MOD13Q1.csv}

For MODIS MOD13Q1, the SummaryQA band

For Landsat
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

filter_qa(ndvi, ndvi = 'NDVI', qa = 'SummaryQA', good = c(0, 1))
}
\seealso{
Other filter: 
\code{\link{filter_ndvi}()},
\code{\link{filter_roll}()},
\code{\link{filter_top}()},
\code{\link{filter_winter}()}
}
\concept{filter}
