% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_irace.R
\name{multi_irace}
\alias{multi_irace}
\title{Execute \code{\link[=irace]{irace()}} multiple times with the same or different scenarios and parameter space definitions.}
\usage{
multi_irace(
  scenarios,
  parameters,
  n = 1L,
  parallel = 1,
  split_output = parallel > 1,
  global_seed = NULL
)
}
\arguments{
\item{scenarios}{\code{list()}\cr A list of scenarios.
If only a single scenario is supplied, it is used for all parameters.}

\item{parameters}{\code{list()}\cr A list of parameter space definitions.
If only a single definition is supplied, it is used for all scenarios.}

\item{n}{\code{integer(1)}\cr The number of repetitions.}

\item{parallel}{\code{integer(1)}\cr The number of workers to use.
A value of \code{1} means sequential execution. Note that \code{parallel > 1} is not supported on Windows.}

\item{split_output}{\code{logical(1)}\cr If \code{TRUE}, the output of \code{\link[=irace]{irace()}} is written to \verb{\{execDir\}/run_\{i\}/irace.out}
instead of the standard output.}

\item{global_seed}{\code{integer(1)}\cr The global seed used to seed the individual runs.}
}
\value{
A list of the outputs of \code{\link[=irace]{irace()}}.
}
\description{
There are three modes of operation:
\itemize{
\item One \code{scenarios} and \code{k} \code{parameters}: \code{k} runs with the same scenario and each parameter space definition.
\item One \code{parameters} and \code{k} \code{scenarios}: \code{k} runs with the same parameter space definition and each scenario.
\item \code{k} \code{parameters} and \code{k} scenarios: \code{k} runs with each scenario and parameter space definition.
}
Each of the \code{k} runs can be repeated \code{n} times by supplying a value for \code{n}.
}
\seealso{
\describe{
\item{\code{\link[=irace]{irace()}}}{the main interface for single irace runs.}
}
}
\concept{running}
