% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.r
\name{ipums_callback}
\alias{ipums_callback}
\alias{IpumsChunkCallback}
\alias{IpumsSideEffectCallback}
\alias{IpumsDataFrameCallback}
\alias{IpumsListCallback}
\alias{IpumsBiglmCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors that have been adapted
for use on IPUMS microdata extracts. Though the callbacks from the
readr package will work, they will not handle implicit decimals
or add value/variable labels to the data.
}
\details{
\describe{
 \item{IpumsSideEffectCallback}{
   Callback function that is used only for side effects, no results are returned.
   Initialize with a function that takes 2 arguments x (which will be the data chunk)
   and an integer that indicates the position of the first observation in the chunk.
   If the function returns \code{FALSE}, no more chunks will be read.
 }
 \item{IpumsDataFrameCallback}{
 Callback function that combines each result together into a data.frame at the end.
   Initialize the same was as IpumsSideEffectCallback, and the results from the
   function will be fed into a data.frame.
 }
 \item{IpumsListCallback}{
   Callback function that returns a list, where each item is the result from a chunk.
   Initalize the same was as IpumsSideEffectCallback.
 }
 \item{IpumsBiglmCallback}{
   Callback function that performs a regression on the full dataset, one chunk
   at a time using the biglm package. Initialize with arguments \code{model} (A
   formula of your model and \code{prep} a function like the other callback arguments
   that prepares the data before running the regression. Other arguments are
   passed to biglm.
 }
 \item{IpumsChunkCallback}{
   (Only needed for advanced usage) Callback interface definition, all
    callback functions for IPUMS data should inherit from this class, and should
    use private method \code{ipumsify} on the data to handle implicit decimals
    and value labels.
  }
}
}
\keyword{internal}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{IpumsChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_ipums_fields}{\code{IpumsChunkCallback$set_ipums_fields()}}
\item \href{#method-clone}{\code{IpumsChunkCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally">}\href{../../hipread/html/ChunkCallback.html#method-finally}{\code{hipread::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="initialize">}\href{../../hipread/html/ChunkCallback.html#method-initialize}{\code{hipread::ChunkCallback$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="receive">}\href{../../hipread/html/ChunkCallback.html#method-receive}{\code{hipread::ChunkCallback$receive()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result">}\href{../../hipread/html/ChunkCallback.html#method-result}{\code{hipread::ChunkCallback$result()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_ipums_fields"></a>}}
\if{latex}{\out{\hypertarget{method-set_ipums_fields}{}}}
\subsection{Method \code{set_ipums_fields()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsChunkCallback$set_ipums_fields(
  data_structure,
  ddi,
  var_attrs,
  rt_ddi = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsSideEffectCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IpumsSideEffectCallback$new()}}
\item \href{#method-receive}{\code{IpumsSideEffectCallback$receive()}}
\item \href{#method-continue}{\code{IpumsSideEffectCallback$continue()}}
\item \href{#method-clone}{\code{IpumsSideEffectCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally">}\href{../../hipread/html/ChunkCallback.html#method-finally}{\code{hipread::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result">}\href{../../hipread/html/ChunkCallback.html#method-result}{\code{hipread::ChunkCallback$result()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields">}\href{../../ipumsr/html/IpumsChunkCallback.html#method-set_ipums_fields}{\code{ipumsr::IpumsChunkCallback$set_ipums_fields()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-continue"></a>}}
\if{latex}{\out{\hypertarget{method-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsDataFrameCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IpumsDataFrameCallback$new()}}
\item \href{#method-receive}{\code{IpumsDataFrameCallback$receive()}}
\item \href{#method-result}{\code{IpumsDataFrameCallback$result()}}
\item \href{#method-finally}{\code{IpumsDataFrameCallback$finally()}}
\item \href{#method-clone}{\code{IpumsDataFrameCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields">}\href{../../ipumsr/html/IpumsChunkCallback.html#method-set_ipums_fields}{\code{ipumsr::IpumsChunkCallback$set_ipums_fields()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsListCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IpumsListCallback$new()}}
\item \href{#method-receive}{\code{IpumsListCallback$receive()}}
\item \href{#method-result}{\code{IpumsListCallback$result()}}
\item \href{#method-finally}{\code{IpumsListCallback$finally()}}
\item \href{#method-clone}{\code{IpumsListCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields">}\href{../../ipumsr/html/IpumsChunkCallback.html#method-set_ipums_fields}{\code{ipumsr::IpumsChunkCallback$set_ipums_fields()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsBiglmCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IpumsBiglmCallback$new()}}
\item \href{#method-receive}{\code{IpumsBiglmCallback$receive()}}
\item \href{#method-result}{\code{IpumsBiglmCallback$result()}}
\item \href{#method-clone}{\code{IpumsBiglmCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally">}\href{../../hipread/html/ChunkCallback.html#method-finally}{\code{hipread::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields">}\href{../../ipumsr/html/IpumsChunkCallback.html#method-set_ipums_fields}{\code{ipumsr::IpumsChunkCallback$set_ipums_fields()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$new(model, prep = function(x, pos) x, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
