% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_summary_to_log10.R
\name{convert_summary_to_log10}
\alias{convert_summary_to_log10}
\title{Convert sample mean and SD to log10-scale}
\usage{
convert_summary_to_log10(sample_mean, sample_SD)
}
\arguments{
\item{sample_mean}{Numeric: one or more sample means}

\item{sample_SD}{Numeric: one or more sample SDs}
}
\value{
A list with two named elements: "log10mean" and "log10SD", the log10-scale
  sample means and log10-scale sample SDs, respectively.
}
\description{
Estimate log10-scale sample mean and standard deviation from natural-scale
sample mean and standard deviation
}
\details{
\eqn{\bar{y}_i} is the natural-scale sample mean for group \eqn{i}. \eqn{s_i}
is the natural-scale sample standard deviation for group \eqn{i}.

\deqn{\textrm{log10-scale sample mean}_i = \log_{10}
\left(\frac{\bar{y}_i^2}{\sqrt{\bar{y}_i^2 + s_i^2}} \right)}

\deqn{
\textrm{log10-scale sample SD}_i =
 \sqrt{
 \log_{10} \left(1 + \frac{s_i^2}{\bar{y}_i^2} \right)
 }
 }
}
\author{
Caroline Ring
}
