% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIA.r
\name{TIA}
\alias{TIA}
\title{Transition level intensity analysis}
\usage{
TIA(crosstabulation, time.points, categories)
}
\arguments{
\item{crosstabulation}{List of crosstabulation tables generated by \code{multicrosstab} function.}

\item{time.points}{a charachter vector showing the time point of each raster layer in chronological order.}

\item{categories}{A charachter vector showing the categories in the map. Order of categories decided bases on the equivalent IDs in the raster attribute table.}
}
\value{
The output is a list of lists. Elements of the list include: transition intensity, uniform transition, transition behavior for gain of a category. These metrics are calculated for each interval.
}
\description{
Transition level intensity analysis
}
\details{
Gets the list of crosstabulation tables, time points and categories vectors and returns a list of gain and loss metrics accompanied with relevant bar graphs.
}
\examples{
raster_2005 <- raster::raster(system.file("external/RASTER_2005.RST", package="intensity.analysis"))
raster_2010 <- raster::raster(system.file("external/RASTER_2010.RST", package="intensity.analysis"))
raster_2012 <- raster::raster(system.file("external/RASTER_2012.RST", package="intensity.analysis"))
raster.layers <- list(raster_2005, raster_2010, raster_2012)
time.points <- c("2005","2010","2012")
categories <- c("Water","Trees","Impervious")
crosstabulation <- multicrosstab(raster.layers, time.points, categories)
TIA.output <- TIA(crosstabulation, time.points, categories)
}
