% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidalgo_postproc.R
\name{clustering}
\alias{clustering}
\alias{print.hidalgo_psm}
\alias{plot.hidalgo_psm}
\title{Posterior similarity matrix and partition estimation}
\usage{
clustering(
  object,
  clustering_method = c("dendrogram", "salso"),
  K = 2,
  nCores = 1,
  ...
)

\method{print}{hidalgo_psm}(x, ...)

\method{plot}{hidalgo_psm}(x, ...)
}
\arguments{
\item{object}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo} function.}

\item{clustering_method}{character indicating the method to use to perform
clustering. It can be
\describe{
       \item{"dendrogram"}{thresholding the adjacency dendrogram with a given
        number (\code{K});}
       \item{"salso"}{estimation via minimization of several partition
       estimation criteria.
       The default loss function is the variation of information.}
       }}

\item{K}{number of clusters to recover by thresholding the
dendrogram obtained from the psm.}

\item{nCores}{parameter for the \code{salso} function: the number of CPU
cores to use. A value of zero indicates to use all cores on the system.}

\item{...}{ignored.}

\item{x}{object of class \code{hidalgo_psm}, obtained from the function
\code{clustering()}.}
}
\value{
list containing the posterior similarity matrix (\code{psm}) and
the estimated partition \code{clust}.
}
\description{
The function computes the posterior similarity (coclustering) matrix (psm)
and estimates a representative partition of the observations from the MCMC
output. The user can provide the desired number of clusters, or estimate a
partition minimizing a loss function on the space of the partitions.
In the latter case, function uses the package \code{salso}
(\href{https://arxiv.org/abs/2105.04451}{Dahl et al., 2021+}),
that the user needs to load.
}
\examples{
\donttest{
library(salso)
X            <- replicate(5,rnorm(500))
X[1:250,1:2] <- 0
h_out        <- Hidalgo(X)
clustering(h_out)
}
}
\references{
David B. Dahl, Devin J. Johnson and Peter Müller (2021). salso: Search
Algorithms and Loss Functions for Bayesian Clustering. R package version
0.3.0. \url{https://CRAN.R-project.org/package=salso}
}
\seealso{
\code{\link{Hidalgo}}, \code{\link[salso]{salso}}
}
