% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fitgam.R
\name{autoplot.fitgam}
\alias{autoplot.fitgam}
\title{Automatically create a ggplot for objects obtained from fit_gam()}
\usage{
\method{autoplot}{fitgam}(
  x,
  conf_int = FALSE,
  color_gam = "steelblue",
  show_observations = FALSE,
  x_stepsize = NULL,
  size_points = 1,
  color_points = "black",
  rotate_labels = FALSE,
  remove_outliers = NULL
)
}
\arguments{
\item{x}{fitgam object produced by \code{fit_gam}}

\item{conf_int}{determines whether 95\% confidence intervals will be plotted. The default is \code{conf_int = FALSE}}

\item{color_gam}{a color can be specified either by name (e.g.: "red") or by hexadecimal code (e.g. : "#FF1234") (default is "steelblue")}

\item{show_observations}{add observed frequency/severity points for each level of the variable for which tariff classes are constructed}

\item{x_stepsize}{set step size for labels horizontal axis}

\item{size_points}{size for points (1 is default)}

\item{color_points}{change the color of the points in the graph ("black" is default)}

\item{rotate_labels}{rotate x-labels 45 degrees (this might be helpful for overlapping x-labels)}

\item{remove_outliers}{do not show observations above this number in the plot. This might be helpful for outliers.}
}
\value{
a ggplot object
}
\description{
Takes an object produced by \code{fit_gam()}, and plots the fitted GAM.
}
\examples{
\dontrun{
library(ggplot2)
library(dplyr)
fit_gam(MTPL, nclaims = nclaims, x = age_policyholder, exposure = exposure) \%>\%
   autoplot(., show_observations = TRUE)
}

}
\author{
Martin Haringa
}
