% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_random.R
\name{get_random}
\alias{get_random}
\title{Get the data from random effects}
\usage{
get_random(x)
}
\arguments{
\item{x}{A fitted mixed model.}
}
\value{
The data from all random effects terms, as data frame. Or \code{NULL}
if model has no random effects.
}
\description{
Returns the data from all random effects terms.
}
\examples{
\dontshow{if (require("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(sleepstudy)
# prepare some data...
sleepstudy$mygrp <- sample(1:5, size = 180, replace = TRUE)
sleepstudy$mysubgrp <- NA
for (i in 1:5) {
  filter_group <- sleepstudy$mygrp == i
  sleepstudy$mysubgrp[filter_group] <-
    sample(1:30, size = sum(filter_group), replace = TRUE)
}

m <- lmer(
  Reaction ~ Days + (1 | mygrp / mysubgrp) + (1 | Subject),
  data = sleepstudy
)

head(get_random(m))
\dontshow{\}) # examplesIf}
}
